/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.wrapper;

import java.nio.channels.ClosedByInterruptException;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.AbstractRecoveryPolicy;
import org.apache.servicecomb.pack.omega.transaction.CompensableInterceptor;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.TransactionTimeoutException;
import org.apache.servicecomb.pack.omega.transaction.annotations.Compensable;
import org.apache.servicecomb.pack.omega.transaction.wrapper.TimeoutProb;
import org.apache.servicecomb.pack.omega.transaction.wrapper.TimeoutProbManager;
import org.aspectj.lang.ProceedingJoinPoint;

public class RecoveryPolicyTimeoutWrapper {
    private AbstractRecoveryPolicy recoveryPolicy;

    public RecoveryPolicyTimeoutWrapper(AbstractRecoveryPolicy recoveryPolicy) {
        this.recoveryPolicy = recoveryPolicy;
    }

    public Object applyTo(ProceedingJoinPoint joinPoint, Compensable compensable, CompensableInterceptor interceptor, OmegaContext context, String parentTxId, int retries) throws Throwable {
        Object output;
        TimeoutProb timeoutProb = TimeoutProbManager.getInstance().addTimeoutProb(compensable.forwardTimeout());
        try {
            output = this.recoveryPolicy.applyTo(joinPoint, compensable, interceptor, context, parentTxId, retries);
            if (timeoutProb.getInterruptFailureException() != null) {
                throw new OmegaException(timeoutProb.getInterruptFailureException());
            }
        }
        catch (InterruptedException e) {
            if (timeoutProb.getInterruptFailureException() != null) {
                throw new OmegaException(timeoutProb.getInterruptFailureException());
            }
            throw new TransactionTimeoutException(e.getMessage(), e);
        }
        catch (IllegalMonitorStateException e) {
            if (timeoutProb.getInterruptFailureException() != null) {
                throw new OmegaException(timeoutProb.getInterruptFailureException());
            }
            throw new TransactionTimeoutException(e.getMessage(), e);
        }
        catch (ClosedByInterruptException e) {
            if (timeoutProb.getInterruptFailureException() != null) {
                throw new OmegaException(timeoutProb.getInterruptFailureException());
            }
            throw new TransactionTimeoutException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            TimeoutProbManager.getInstance().removeTimeoutProb(timeoutProb);
        }
        return output;
    }
}

