/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.tcc;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.common.TransactionStatus;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.TransactionContext;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.TransactionContextHelper;
import org.apache.servicecomb.pack.omega.transaction.annotations.Participate;
import org.apache.servicecomb.pack.omega.transaction.tcc.ParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.ParticipationEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.ParticipationStartedEvent;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TccParticipatorAspect
extends TransactionContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext context;
    private final TccMessageSender tccMessageSender;
    private final ParametersContext parametersContext;

    public TccParticipatorAspect(TccMessageSender tccMessageSender, OmegaContext context, ParametersContext parametersContext) {
        this.context = context;
        this.context.verify();
        this.tccMessageSender = tccMessageSender;
        this.parametersContext = parametersContext;
    }

    @Around(value="execution(@org.apache.servicecomb.pack.omega.transaction.annotations.Participate * *(..)) && @annotation(participate)")
    Object advise(ProceedingJoinPoint joinPoint, Participate participate) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        TransactionContext transactionContext = this.extractTransactionContext(joinPoint.getArgs());
        if (transactionContext != null) {
            this.populateOmegaContext(this.context, transactionContext);
        }
        String localTxId = this.context.localTxId();
        String cancelMethod = this.callbackMethodSignature(joinPoint, participate.cancelMethod(), method);
        String confirmMethod = this.callbackMethodSignature(joinPoint, participate.confirmMethod(), method);
        this.context.newLocalTxId();
        LOG.debug("Updated context {} for participate method {} ", (Object)this.context, (Object)method.toString());
        try {
            AlphaResponse response = this.tccMessageSender.participationStart(new ParticipationStartedEvent(this.context.globalTxId(), this.context.localTxId(), localTxId, confirmMethod, cancelMethod));
            if (response.aborted()) {
                throw new OmegaException("transcation has aborted: " + this.context.globalTxId());
            }
            Object result = joinPoint.proceed();
            this.tccMessageSender.participationEnd(new ParticipationEndedEvent(this.context.globalTxId(), this.context.localTxId(), localTxId, confirmMethod, cancelMethod, TransactionStatus.Succeed));
            this.parametersContext.putParameters(this.context.localTxId(), joinPoint.getArgs());
            LOG.debug("Participate Transaction with context {} has finished.", (Object)this.context);
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OmegaException)) {
                this.tccMessageSender.participationEnd(new ParticipationEndedEvent(this.context.globalTxId(), this.context.localTxId(), localTxId, confirmMethod, cancelMethod, TransactionStatus.Failed));
            }
            LOG.error("Participate Transaction with context {} failed.", (Object)this.context, (Object)throwable);
            throw throwable;
        }
        finally {
            this.context.setLocalTxId(localTxId);
        }
    }

    String callbackMethodSignature(ProceedingJoinPoint joinPoint, String callbackMethod, Method tryMethod) throws NoSuchMethodException {
        return callbackMethod.isEmpty() ? "" : joinPoint.getTarget().getClass().getDeclaredMethod(callbackMethod, tryMethod.getParameterTypes()).toString();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

