/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.TransactionContext;
import org.apache.servicecomb.pack.omega.transaction.CompensableInterceptor;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.RecoveryPolicy;
import org.apache.servicecomb.pack.omega.transaction.RecoveryPolicyFactory;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.TransactionContextHelper;
import org.apache.servicecomb.pack.omega.transaction.annotations.Compensable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=200)
public class TransactionAspect
extends TransactionContextHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext context;
    private final CompensableInterceptor interceptor;

    public TransactionAspect(SagaMessageSender sender, OmegaContext context) {
        this.context = context;
        this.context.verify();
        this.interceptor = new CompensableInterceptor(context, sender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(@org.apache.servicecomb.pack.omega.transaction.annotations.Compensable * *(..)) && @annotation(compensable)")
    Object advise(ProceedingJoinPoint joinPoint, Compensable compensable) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        TransactionContext transactionContext = this.extractTransactionContext(joinPoint.getArgs());
        if (transactionContext != null) {
            this.populateOmegaContext(this.context, transactionContext);
        }
        if (this.context.globalTxId() == null) {
            throw new OmegaException("Cannot find the globalTxId from OmegaContext. Please using @SagaStart to start a global transaction.");
        }
        String localTxId = this.context.localTxId();
        this.context.newLocalTxId();
        LOG.debug("Updated context {} for compensable method {} ", (Object)this.context, (Object)method.toString());
        int forwardRetries = compensable.forwardRetries();
        RecoveryPolicy recoveryPolicy = RecoveryPolicyFactory.getRecoveryPolicy(forwardRetries);
        try {
            Object object = recoveryPolicy.apply(joinPoint, compensable, this.interceptor, this.context, localTxId, forwardRetries);
            return object;
        }
        finally {
            this.context.setLocalTxId(localTxId);
            LOG.debug("Restored context back to {}", (Object)this.context);
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

