/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.annotations.SagaStart;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.SagaStartAnnotationProcessor;
import org.apache.servicecomb.pack.omega.transaction.wrapper.SagaStartAnnotationProcessorTimeoutWrapper;
import org.apache.servicecomb.pack.omega.transaction.wrapper.SagaStartAnnotationProcessorWrapper;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=100)
public class SagaStartAspect {
    private final SagaStartAnnotationProcessor sagaStartAnnotationProcessor;
    private final OmegaContext context;

    public SagaStartAspect(SagaMessageSender sender, OmegaContext context) {
        this.context = context;
        this.sagaStartAnnotationProcessor = new SagaStartAnnotationProcessor(context, sender);
    }

    @Around(value="execution(@org.apache.servicecomb.pack.omega.context.annotations.SagaStart * *(..)) && @annotation(sagaStart)")
    Object advise(ProceedingJoinPoint joinPoint, SagaStart sagaStart) throws Throwable {
        this.initializeOmegaContext();
        if (this.context.getAlphaMetas().isAkkaEnabled() && sagaStart.timeout() > 0) {
            SagaStartAnnotationProcessorTimeoutWrapper wrapper = new SagaStartAnnotationProcessorTimeoutWrapper(this.sagaStartAnnotationProcessor);
            return wrapper.apply(joinPoint, sagaStart, this.context);
        }
        SagaStartAnnotationProcessorWrapper wrapper = new SagaStartAnnotationProcessorWrapper(this.sagaStartAnnotationProcessor);
        return wrapper.apply(joinPoint, sagaStart, this.context);
    }

    private void initializeOmegaContext() {
        this.context.setLocalTxId(this.context.newGlobalTxId());
    }
}

