/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import javax.transaction.TransactionalException;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.SagaAbortedEvent;
import org.apache.servicecomb.pack.omega.transaction.SagaEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.SagaStartedEvent;
import org.apache.servicecomb.pack.omega.transaction.TxAbortedEvent;

public class SagaStartAnnotationProcessor {
    private final OmegaContext omegaContext;
    private final SagaMessageSender sender;

    public SagaStartAnnotationProcessor(OmegaContext omegaContext, SagaMessageSender sender) {
        this.omegaContext = omegaContext;
        this.sender = sender;
    }

    public AlphaResponse preIntercept(int timeout) {
        try {
            return this.sender.send(new SagaStartedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), timeout));
        }
        catch (OmegaException e) {
            throw new TransactionalException(e.getMessage(), e.getCause());
        }
    }

    public void postIntercept(String parentTxId) {
        AlphaResponse response = this.sender.send(new SagaEndedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId()));
        if (response.aborted()) {
            throw new OmegaException("transaction " + parentTxId + " is aborted");
        }
    }

    public void onError(String compensationMethod, Throwable throwable) {
        String globalTxId = this.omegaContext.globalTxId();
        if (this.omegaContext.getAlphaMetas().isAkkaEnabled()) {
            this.sender.send(new SagaAbortedEvent(globalTxId, this.omegaContext.localTxId(), null, compensationMethod, throwable));
        } else {
            this.sender.send(new TxAbortedEvent(globalTxId, this.omegaContext.localTxId(), null, compensationMethod, throwable));
        }
    }
}

