/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transport.resttemplate;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

class TransactionClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;

    TransactionClientHttpRequestInterceptor(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.omegaContext != null && this.omegaContext.globalTxId() != null) {
            request.getHeaders().add("X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId());
            request.getHeaders().add("X-Pack-Local-Transaction-Id", this.omegaContext.localTxId());
            LOG.debug("Added {} {} and {} {} to request header", new Object[]{"X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId(), "X-Pack-Local-Transaction-Id", this.omegaContext.localTxId()});
        } else {
            LOG.debug("Cannot inject transaction ID, as the OmegaContext is null or cannot get the globalTxId.");
        }
        return execution.execute(request, body);
    }
}

