/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.server;

import com.google.common.eventbus.EventBus;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyServerBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.net.ssl.SSLException;
import org.apache.servicecomb.pack.alpha.core.event.GrpcStartableStartedEvent;
import org.apache.servicecomb.pack.alpha.server.GrpcServerConfig;
import org.apache.servicecomb.pack.alpha.server.GrpcStartable;
import org.apache.servicecomb.pack.alpha.server.ServerStartable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GrpcStartable
implements ServerStartable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Server server;
    private final GrpcServerConfig serverConfig;
    private final EventBus eventBus;

    public GrpcStartable(GrpcServerConfig serverConfig, EventBus eventBus, BindableService ... services) throws IOException {
        block5: {
            this.serverConfig = serverConfig;
            this.eventBus = eventBus;
            OptionalInt unusedPort = this.findUnusedPort(serverConfig);
            if (!unusedPort.isPresent()) break block5;
            ServerBuilder serverBuilder = this.getServerBuilder(unusedPort.getAsInt());
            if (serverConfig.isSslEnable()) {
                try {
                    ((NettyServerBuilder)serverBuilder).sslContext(this.getSslContextBuilder(serverConfig).build());
                }
                catch (SSLException e) {
                    throw new IllegalStateException("Unable to setup grpc to use SSL.", e);
                }
            }
            Arrays.stream(services).forEach(arg_0 -> ((ServerBuilder)serverBuilder).addService(arg_0));
            this.server = serverBuilder.build();
            serverConfig.setPort(unusedPort.getAsInt());
        }
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((Server)this.server).shutdown()));
        try {
            this.eventBus.post((Object)new GrpcStartableStartedEvent(this.serverConfig.getPort()));
            this.server.start();
            this.server.awaitTermination();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to start grpc server.", e);
        }
        catch (InterruptedException e) {
            LOG.error("grpc server was interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public GrpcServerConfig getGrpcServerConfig() {
        return this.serverConfig;
    }

    private ServerBuilder getServerBuilder(int port) {
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(this.serverConfig.getHost(), port)).channelType(this.selectorServerChannel()).bossEventLoopGroup(this.selectorEventLoopGroup(1)).workerEventLoopGroup(this.selectorEventLoopGroup(0));
    }

    private SslContextBuilder getSslContextBuilder(GrpcServerConfig config) {
        Properties prop = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            prop.load(classLoader.getResourceAsStream("ssl.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read ssl.properties.", e);
        }
        InputStream cert = this.getInputStream(classLoader, config.getCert(), "Server Cert");
        InputStream key = this.getInputStream(classLoader, config.getKey(), "Server Key");
        SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((InputStream)cert, (InputStream)key).protocols(new String[]{prop.getProperty("protocols")}).ciphers(Arrays.asList(prop.getProperty("ciphers").split(",")));
        if (config.isMutualAuth()) {
            InputStream clientCert = this.getInputStream(classLoader, config.getClientCert(), "Client Cert");
            sslClientContextBuilder.trustManager(clientCert);
            sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        return GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)SslProvider.OPENSSL);
    }

    private InputStream getInputStream(ClassLoader classLoader, String resource, String config) {
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is == null) {
            throw new IllegalStateException("Cannot load the " + config + " from " + resource);
        }
        return is;
    }

    private OptionalInt findUnusedPort(GrpcServerConfig serverConfig) throws IOException {
        IntStream trialPorts;
        if (serverConfig.getPort() == 0) {
            LOG.info("No explicit port is given, system will pick up an ephemeral port.");
            if (serverConfig.isPortAutoIncrement() && serverConfig.getPortCount() > 0) {
                LOG.info("Port trial count must be positive: {}", (Object)serverConfig.getPortCount());
                trialPorts = IntStream.range(serverConfig.getInitialPort(), serverConfig.getInitialPort() + serverConfig.getPortCount());
            } else {
                trialPorts = IntStream.range(serverConfig.getInitialPort(), serverConfig.getInitialPort() + 1);
            }
        } else {
            trialPorts = IntStream.range(serverConfig.getPort(), serverConfig.getPort() + 1);
        }
        IOException[] error = new IOException[1];
        OptionalInt bindPort = trialPorts.filter(port -> {
            try {
                ServerSocketChannel preBindServerSocketChannel = null;
                ServerSocket preBindServerSocket = null;
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverConfig.getHost(), port);
                try {
                    preBindServerSocketChannel = ServerSocketChannel.open();
                    preBindServerSocket = preBindServerSocketChannel.socket();
                    preBindServerSocket.setReuseAddress(true);
                    preBindServerSocket.setSoTimeout((int)TimeUnit.SECONDS.toMillis(1L));
                    preBindServerSocket.bind(inetSocketAddress, 100);
                    LOG.info("Bind successful to inet socket address {}", (Object)inetSocketAddress);
                    preBindServerSocketChannel.configureBlocking(false);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    LOG.info("Bind failed to inet socket address {}", (Object)inetSocketAddress);
                    throw e;
                }
                finally {
                    if (preBindServerSocket != null) {
                        try {
                            preBindServerSocket.close();
                        }
                        catch (IOException ex) {
                            LOG.error("closeResource failed", (Throwable)ex);
                        }
                    }
                    if (preBindServerSocketChannel != null) {
                        try {
                            preBindServerSocketChannel.close();
                        }
                        catch (IOException ex) {
                            LOG.error("closeResource failed", (Throwable)ex);
                        }
                    }
                }
            }
            catch (IOException e2) {
                error[0] = e2;
                return false;
            }
        }).findAny();
        if (bindPort.isPresent()) {
            return bindPort;
        }
        throw error[0];
    }

    private Class<? extends ServerChannel> selectorServerChannel() {
        Class<NioServerSocketChannel> channel = NioServerSocketChannel.class;
        if (this.serverConfig.isNativeTransport()) {
            if (OSInfo.isLinux()) {
                channel = EpollServerSocketChannel.class;
            } else if (OSInfo.isMacOS()) {
                channel = KQueueServerSocketChannel.class;
            }
        }
        LOG.info("Netty channel type is " + channel.getSimpleName());
        return channel;
    }

    private EventLoopGroup selectorEventLoopGroup(int nThreads) {
        NioEventLoopGroup group = new NioEventLoopGroup(nThreads);
        if (this.serverConfig.isNativeTransport()) {
            if (OSInfo.isLinux()) {
                group = new EpollEventLoopGroup(nThreads);
            } else if (OSInfo.isMacOS()) {
                group = new KQueueEventLoopGroup(nThreads);
            }
        }
        LOG.info("Netty event loop group is " + group.getClass().getSimpleName());
        return group;
    }
}

