/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.server;

import com.google.common.eventbus.EventBus;
import io.grpc.BindableService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.servicecomb.pack.alpha.core.CompositeOmegaCallback;
import org.apache.servicecomb.pack.alpha.core.NodeStatus;
import org.apache.servicecomb.pack.alpha.core.OmegaCallback;
import org.apache.servicecomb.pack.alpha.core.PendingTaskRunner;
import org.apache.servicecomb.pack.alpha.core.PushBackOmegaCallback;
import org.apache.servicecomb.pack.alpha.server.GrpcServerConfig;
import org.apache.servicecomb.pack.alpha.server.GrpcStartable;
import org.apache.servicecomb.pack.alpha.server.ServerStartable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EntityScan(basePackages={"org.apache.servicecomb.pack.alpha"})
@Configuration
public class AlphaConfig {
    private final BlockingQueue<Runnable> pendingCompensations = new LinkedBlockingQueue();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    @Value(value="${alpha.compensation.retry.delay:3000}")
    private int delay;
    @Value(value="${alpha.tx.timeout-seconds:600}")
    private int globalTxTimeoutSeconds;
    @Value(value="${alpha.cluster.master.enabled:false}")
    private boolean masterEnabled;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    ApplicationEventPublisher applicationEventPublisher;

    @Bean(value={"alphaEventBus"})
    EventBus alphaEventBus() {
        return new EventBus("alphaEventBus");
    }

    @Bean
    Map<String, Map<String, OmegaCallback>> omegaCallbacks() {
        return new ConcurrentHashMap<String, Map<String, OmegaCallback>>();
    }

    @Bean
    OmegaCallback omegaCallback(Map<String, Map<String, OmegaCallback>> callbacks) {
        return new PushBackOmegaCallback(this.pendingCompensations, (OmegaCallback)new CompositeOmegaCallback(callbacks));
    }

    @Bean
    ScheduledExecutorService compensationScheduler() {
        return this.scheduler;
    }

    @Bean
    NodeStatus nodeStatus() {
        if (this.masterEnabled) {
            return new NodeStatus(NodeStatus.TypeEnum.SLAVE);
        }
        return new NodeStatus(NodeStatus.TypeEnum.MASTER);
    }

    @Bean
    ServerStartable serverStartableWithAkka(GrpcServerConfig serverConfig, @Qualifier(value="alphaEventBus") EventBus eventBus, List<BindableService> bindableServices) throws IOException {
        GrpcStartable bootstrap = new GrpcStartable(serverConfig, eventBus, bindableServices.toArray(new BindableService[0]));
        new Thread(() -> ((ServerStartable)bootstrap).start()).start();
        return bootstrap;
    }

    @PostConstruct
    void init() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        new PendingTaskRunner(this.pendingCompensations, this.delay).run();
    }

    @PreDestroy
    void shutdown() {
        this.scheduler.shutdownNow();
    }
}

