/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class PackageRenamer {
    int numberOfTotalFile = 0;
    int numberOfChangedFile = 0;
    boolean specifyLogFile = false;
    PrintWriter outLog = null;
    String logFileString = null;
    File logFile;
    File sourceRootDirFile;
    File destinationRootDir;
    String sourceProperties;
    Properties properties = null;
    String propertiesFileName;
    boolean VERBOSE = true;
    protected static final String SYSTEM_OUT = "System.out";
    BufferedReader reader = null;
    String[] UNSUPPORTED_EXTENSIONS = new String[]{"jar", "zip", "ear", "war", "dll", "class", "exe"};
    int BUFSIZ = 4096;
    static final String CR = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("line.separator");
        }
    }) : System.getProperty("line.separator");

    public PackageRenamer() {
        this(PackageRenamer.getDefaultPropertiesFileName());
    }

    public PackageRenamer(String propertiesFileName) {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println(this.bannerText());
        this.sourceRootDirFile = this.existingDirectoryFromPrompt();
        System.out.println("");
        this.destinationRootDir = this.promptForDestinationDirectory();
        System.out.println("");
        this.propertiesFileName = propertiesFileName;
        this.outLog = this.streamForNonExistentFilePrompt();
        this.properties = this.readChangesFile(propertiesFileName);
    }

    public PackageRenamer(String[] args) {
        this.propertiesFileName = args[0];
        this.sourceRootDirFile = this.buildAndCheckExistingDirFile(args[1]);
        this.destinationRootDir = this.buildAndCheckDestinationFile(args[2]);
        this.outLog = args.length == 4 ? this.buildAndCheckLogWriter(args[3]) : this.buildAndCheckLogWriter(SYSTEM_OUT);
        this.properties = this.readChangesFile(args[0]);
        this.logln(this.bannerText());
    }

    protected String bannerText() {
        StringBuilder stringBuilder = new StringBuilder(CR.length() * 3 + 66 + 42);
        stringBuilder.append(CR);
        stringBuilder.append("NOTE: The package renamer is meant to be run on plain text files. ");
        stringBuilder.append(CR);
        stringBuilder.append("A rename will NOT be done on binary files.");
        stringBuilder.append(CR);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void binaryCopy(File inFile, File outFile) throws FileNotFoundException, IOException {
        byte[] buf = new byte[this.BUFSIZ];
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            FileInputStream in = new FileInputStream(inFile);
            try {
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    int nBytesRead;
                    while ((nBytesRead = in.read(buf)) != -1) {
                        out.write(buf, 0, nBytesRead);
                    }
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected boolean bufferContainsNullChar(byte[] buffer, int bufferLength) {
        int i = 0;
        while (i < bufferLength) {
            if (buffer[i] == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public File buildAndCheckDestinationFile(String aDirString) {
        File[] dirContent;
        if (aDirString == null) {
            throw new PackageRenamerException("Invalid destination directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (aDirFile.exists() && (dirContent = aDirFile.listFiles()) != null && dirContent.length != 0) {
            throw new PackageRenamerException("Output Directory:" + CR + "  '" + aDirString + "'" + CR + "exists and is not empty.");
        }
        if (!aDirFile.isAbsolute()) {
            throw new PackageRenamerException("A relative destination directory was entered:" + CR + "  '" + aDirString + "'" + CR + "The directory must be absolute.");
        }
        if (PackageRenamer.directoryIsSubdirectory(this.sourceRootDirFile, aDirFile)) {
            throw new PackageRenamerException("Invalid destination directory entered:" + CR + "  '" + aDirString + "'" + CR + "It cannot be a sub-directory of the source directory.");
        }
        return aDirFile;
    }

    public File buildAndCheckExistingDirFile(String aDirString) {
        if (aDirString == null) {
            throw new PackageRenamerException("Invalid source directory entered.");
        }
        File aDirFile = new File(aDirString);
        if (!aDirFile.exists() || !aDirFile.isDirectory()) {
            throw new PackageRenamerException("Input Directory:" + CR + "  '" + aDirString + "'" + CR + "does not exist or is not a directory.");
        }
        if (!aDirFile.isAbsolute()) {
            throw new PackageRenamerException("A relative source directory was entered:" + CR + "  '" + aDirString + "'" + CR + "The directory must be absolute.");
        }
        return aDirFile;
    }

    public PrintWriter buildAndCheckLogWriter(String logFileString) {
        if (logFileString == null) {
            throw new PackageRenamerException("Invalid log file name entered.");
        }
        try {
            if (logFileString.equals(SYSTEM_OUT)) {
                return new PrintWriter(System.out);
            }
            File aLogFile = new File(logFileString);
            if (aLogFile.exists()) {
                throw new PackageRenamerException("Specified log file cannot be created:" + CR + "  '" + logFileString + "'");
            }
            FileWriter writerLog = new FileWriter(logFileString);
            return new PrintWriter(writerLog);
        }
        catch (IOException ioException) {
            throw new PackageRenamerException("Unhandled IOException occurred while configuring log file: '" + logFileString + "', " + ioException.getMessage());
        }
    }

    protected void cleanup() {
        if (this.outLog != null) {
            this.outLog.close();
        }
    }

    public void createDestinationDirectory(File aDirectory) {
        if (!aDirectory.exists()) {
            if (!aDirectory.mkdirs()) {
                throw new PackageRenamerException("Error while creating directory:" + CR + "  '" + aDirectory.toString() + "'");
            }
        } else {
            throw new PackageRenamerException("Error directory: '" + aDirectory.toString() + "' already exists but shouldn't.");
        }
    }

    public static boolean directoryIsSubdirectory(File directory1, File directory2) {
        if (directory2 == null) {
            return false;
        }
        if (directory1.equals(directory2)) {
            return true;
        }
        return PackageRenamer.directoryIsSubdirectory(directory1, directory2.getParentFile());
    }

    public File existingDirectoryFromPrompt() {
        System.out.print("Enter the path of the directory which contains the files to rename:" + CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the source directory: " + exception.getMessage());
        }
        return this.buildAndCheckExistingDirFile(aLine);
    }

    public static String getDefaultPropertiesFileName() {
        String currentDirectory = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        }) : System.getProperty("user.dir");
        return String.valueOf(currentDirectory) + File.separator + "packageRename.properties";
    }

    public synchronized BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.reader;
    }

    public boolean isExtensionSupported(String extension) {
        return true;
    }

    public void logln(String str) {
        this.outLog.println(str);
        this.outLog.flush();
    }

    public static void main(String[] args) {
        PackageRenamer instance = null;
        try {
            if (args.length == 0) {
                instance = new PackageRenamer();
                instance.run();
            } else if (args.length == 1) {
                instance = new PackageRenamer(args[0]);
                instance.run();
            } else if (args.length == 3 || args.length == 4) {
                instance = new PackageRenamer(args);
                instance.run();
            } else {
                PackageRenamer.usage();
                System.exit(-1);
            }
        }
        catch (PackageRenamerException exception) {
            PackageRenamer.usage();
            System.err.println("**************************************************************************");
            System.err.println("Error during package rename. PACKAGE RENAME FAILED.");
            System.err.println(exception.getMessage());
            System.err.println("**************************************************************************");
            System.exit(-1);
        }
        catch (Throwable unknowException) {
            System.err.println("Unhandled exception was thrown during rename:");
            unknowException.printStackTrace();
            System.exit(-1);
        }
        instance.logln("");
        instance.logln("PACKAGE RENAME WAS SUCCESSFUL");
        instance.cleanup();
    }

    public String parseFileExtension(File aFile) {
        int index = aFile.getName().lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return aFile.getName().substring(index + 1);
    }

    protected File promptForDestinationDirectory() {
        System.out.print("Enter the path of the directory to which files are to be copied:" + CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the destination directory specified: " + exception.getMessage());
        }
        return this.buildAndCheckDestinationFile(aLine);
    }

    public Properties readChangesFile(String filename) {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(filename);
                props.load(in);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PackageRenamerException("Properties file was not found:" + CR + "  '" + filename + "'");
            }
            catch (IOException ioException) {
                throw new PackageRenamerException("IO error occurred while reading the properties file:'" + filename + "'" + ioException.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
        this.logln("Using properties file: " + filename);
        return props;
    }

    public void run() {
        this.logln("LOG MESSAGES FROM packageRenamer");
        this.logln("" + new Date());
        this.logln("");
        this.logln("INPUT: -----------------> " + this.sourceRootDirFile.toString());
        this.logln("OUTPUT: ----------------> " + this.destinationRootDir.toString());
        this.logln("");
        this.logln("Verifying root output directory...");
        if (!this.destinationRootDir.exists()) {
            this.logln("");
            this.logln("Creating root output directory...");
            this.createDestinationDirectory(this.destinationRootDir);
            this.logln("");
        }
        this.logln("Verifying root output directory...DONE");
        this.logln("");
        this.logln("List of changed file(s): ");
        this.logln("");
        this.traverseSourceDirectory(this.sourceRootDirFile);
        this.logln("");
        this.logln("Total Changed File(s): ------> " + this.numberOfChangedFile);
        this.logln("Total File(s):         ------> " + this.numberOfTotalFile);
        this.logln("");
    }

    protected PrintWriter streamForNonExistentFilePrompt() {
        System.out.print("Enter the absolute path of the log file [Hit Enter for SYSTEM.OUT]:" + CR + "> ");
        String aLine = null;
        try {
            aLine = this.getReader().readLine();
        }
        catch (IOException exception) {
            throw new PackageRenamerException("Error while reading the name of the log file: " + exception.getMessage());
        }
        if (aLine != null && aLine.length() == 0) {
            return this.buildAndCheckLogWriter(SYSTEM_OUT);
        }
        return this.buildAndCheckLogWriter(aLine);
    }

    /*
     * Exception decompiling
     */
    public void runSearchAndReplacePackageName(File sourceFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String replace(String str, String oldChars, String newChars) {
        int pos;
        int len = newChars.length();
        int lastPos = pos = str.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = str.substring(0, pos);
            String lastPart = str.substring(pos + oldChars.length(), str.length());
            str = String.valueOf(firstPart) + newChars + lastPart;
            lastPos = pos + len;
            pos = str.indexOf(oldChars, lastPos);
        }
        return str;
    }

    public String returnNewFileNameIfRequired(String aSourceFileNameWithoutRoot) {
        Enumeration<Object> enumtr = this.properties.keys();
        while (enumtr.hasMoreElements()) {
            String key = (String)enumtr.nextElement();
            if (aSourceFileNameWithoutRoot.indexOf(key) == -1) continue;
            aSourceFileNameWithoutRoot = PackageRenamer.replace(aSourceFileNameWithoutRoot, key, (String)this.properties.get(key));
        }
        return aSourceFileNameWithoutRoot;
    }

    public void traverseSourceDirectory(File aDirectoryString) {
        Objects.requireNonNull(aDirectoryString);
        File[] filesAndDirectories = aDirectoryString.listFiles();
        if (filesAndDirectories == null) {
            return;
        }
        int i = 0;
        while (i < filesAndDirectories.length) {
            File fileOrDirectory = filesAndDirectories[i];
            if (fileOrDirectory.isDirectory()) {
                String sourceDirectoryName = fileOrDirectory.toString();
                String destinationDirectoryName = String.valueOf(this.destinationRootDir.toString()) + sourceDirectoryName.substring(this.sourceRootDirFile.toString().length(), sourceDirectoryName.length());
                this.createDestinationDirectory(new File(destinationDirectoryName));
                this.traverseSourceDirectory(fileOrDirectory);
            } else {
                ++this.numberOfTotalFile;
                String fileExtension = this.parseFileExtension(fileOrDirectory);
                if (this.isExtensionSupported(fileExtension)) {
                    this.runSearchAndReplacePackageName(fileOrDirectory);
                }
            }
            ++i;
        }
    }

    public static void usage() {
        System.out.println("");
        System.out.println("TopLink Package Renamer");
        System.out.println("-----------------------");
        System.out.println("");
        System.out.println("The package  renamer should  be run  once on user source code, configuration");
        System.out.println("files,  and   Mapping  Workbench  project  files  that  have  references  to");
        System.out.println("pre-Oracle 9iAS TopLink 9.0.3  API  packages.  The package renamer  works on");
        System.out.println("plain text files and should NOT be run on binary files such as JAR files.");
        System.out.println("");
        System.out.println("The package renamer supports two command line usages. A call which specifies");
        System.out.println("all the required arguments, and  a  call which takes only one parameter.  In");
        System.out.println("this last case, the user is prompted for the missing arguments.");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file>");
        System.out.println("");
        System.out.println("OR");
        System.out.println("");
        System.out.println("java org.eclipse.persistence.tools.PackageRenamer <properties-file> <source-root-directory> <destination-root-directory> [ <log-file> ]");
        System.out.println("");
        System.out.println("where:");
        System.out.println("\t<properties-file> - File containing  a list of  old and new package");
        System.out.println("\tnames.");
        System.out.println("");
        System.out.println("\t<source-root-directory> - Absolute path name of the directory which");
        System.out.println("\tcontains all the file to be converted.  The <source-root-directory>");
        System.out.println("\twill be searched recursively for files  to convert.  This directory");
        System.out.println("\tshould contain only the plain text files to be converted.");
        System.out.println("");
        System.out.println("\t<destination-root-directory> - Absolute path name of  the directory");
        System.out.println("\twhere the converted directory  structure will be copied.  All files");
        System.out.println("\twill be copied to  the new directory structure whether changes were");
        System.out.println("\tmade or not. This directory must either not exist or be empty.");
        System.out.println("");
        System.out.println("\t<log-file> - The logging  of  the  renaming process will be written");
        System.out.println("\tto the <log-file>.  If no  <log-file>  is  specified  then  logging");
        System.out.println("\twill be written to standard output.");
        System.out.println("");
    }

    public static final class PackageRenamerException
    extends RuntimeException {
        public PackageRenamerException(String aMessage) {
            super(aMessage);
        }
    }
}

