/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.context;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ServiceConfig {
    private final String serviceName;
    private final String instanceId;
    private static final int MAX_LENGTH = 35;

    public ServiceConfig(String serviceName) {
        this(serviceName, null);
    }

    public ServiceConfig(String serviceName, String instanceId) {
        this.serviceName = serviceName;
        if (instanceId == null || "".equalsIgnoreCase(instanceId.trim())) {
            try {
                this.instanceId = serviceName + "-" + InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.instanceId = instanceId = instanceId.trim();
        }
        if (this.instanceId.length() > 35) {
            throw new IllegalArgumentException(String.format("The instanceId length exceeds maximum length limit [%d].", 35));
        }
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String instanceId() {
        return this.instanceId;
    }
}

