/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transport.dubbo;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Activate(group={"consumer"})
public class PackDubboConsumerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired(required=false)
    private OmegaContext omegaContext;

    public void setOmegaContext(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.omegaContext != null) {
            invocation.getAttachments().put("X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId());
            invocation.getAttachments().put("X-Pack-Local-Transaction-Id", this.omegaContext.localTxId());
        }
        if (this.omegaContext != null && this.omegaContext.globalTxId() != null) {
            LOG.debug("Added {} {} and {} {} to dubbo invocation", new Object[]{"X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId(), "X-Pack-Local-Transaction-Id", this.omegaContext.localTxId()});
        } else {
            LOG.debug("Cannot inject transaction ID, as the OmegaContext is null or cannot get the globalTxId.");
        }
        if (invoker != null) {
            return invoker.invoke(invocation);
        }
        return null;
    }
}

