/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.tcc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import org.apache.servicecomb.pack.contract.grpc.GrpcAck;
import org.apache.servicecomb.pack.contract.grpc.GrpcParticipationEndedEvent;
import org.apache.servicecomb.pack.contract.grpc.GrpcParticipationStartedEvent;
import org.apache.servicecomb.pack.contract.grpc.GrpcServiceConfig;
import org.apache.servicecomb.pack.contract.grpc.GrpcTccCoordinatedEvent;
import org.apache.servicecomb.pack.contract.grpc.GrpcTccTransactionEndedEvent;
import org.apache.servicecomb.pack.contract.grpc.GrpcTccTransactionStartedEvent;
import org.apache.servicecomb.pack.contract.grpc.ServerMeta;
import org.apache.servicecomb.pack.contract.grpc.TccEventServiceGrpc;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.tcc.GrpcCoordinateStreamObserver;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageHandler;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.CoordinatedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.ParticipationEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.ParticipationStartedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.TccEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.TccStartedEvent;

public class GrpcTccClientMessageSender
implements TccMessageSender {
    private final GrpcServiceConfig serviceConfig;
    private final String target;
    private final TccEventServiceGrpc.TccEventServiceBlockingStub tccBlockingEventService;
    private final TccEventServiceGrpc.TccEventServiceStub tccAsyncEventService;
    private final GrpcCoordinateStreamObserver observer;

    public GrpcTccClientMessageSender(ServiceConfig serviceConfig, ManagedChannel channel, String address, TccMessageHandler handler, LoadBalanceContext loadContext) {
        this.target = address;
        this.tccBlockingEventService = TccEventServiceGrpc.newBlockingStub((Channel)channel);
        this.tccAsyncEventService = TccEventServiceGrpc.newStub((Channel)channel);
        this.serviceConfig = this.serviceConfig(serviceConfig.serviceName(), serviceConfig.instanceId());
        this.observer = new GrpcCoordinateStreamObserver(loadContext, (MessageSender)this, handler);
    }

    public void onConnected() {
        this.tccAsyncEventService.onConnected(this.serviceConfig, (StreamObserver)this.observer);
    }

    public void onDisconnected() {
        this.tccBlockingEventService.onDisconnected(this.serviceConfig);
    }

    public ServerMeta onGetServerMeta() {
        return null;
    }

    public void close() {
    }

    public String target() {
        return this.target;
    }

    public AlphaResponse participationStart(ParticipationStartedEvent participationStartedEvent) {
        GrpcAck grpcAck = this.tccBlockingEventService.onParticipationStarted(this.convertTo(participationStartedEvent));
        return new AlphaResponse(grpcAck.getAborted());
    }

    public AlphaResponse participationEnd(ParticipationEndedEvent participationEndedEvent) {
        GrpcAck grpcAck = this.tccBlockingEventService.onParticipationEnded(this.convertTo(participationEndedEvent));
        return new AlphaResponse(grpcAck.getAborted());
    }

    public AlphaResponse tccTransactionStart(TccStartedEvent tccStartEvent) {
        GrpcAck grpcAck = this.tccBlockingEventService.onTccTransactionStarted(this.convertTo(tccStartEvent));
        return new AlphaResponse(grpcAck.getAborted());
    }

    public AlphaResponse tccTransactionStop(TccEndedEvent tccEndEvent) {
        GrpcAck grpcAck = this.tccBlockingEventService.onTccTransactionEnded(this.convertTo(tccEndEvent));
        return new AlphaResponse(grpcAck.getAborted());
    }

    public AlphaResponse coordinate(CoordinatedEvent coordinatedEvent) {
        GrpcAck grpcAck = this.tccBlockingEventService.onTccCoordinated(this.convertTo(coordinatedEvent));
        return new AlphaResponse(grpcAck.getAborted());
    }

    private GrpcTccCoordinatedEvent convertTo(CoordinatedEvent coordinatedEvent) {
        return GrpcTccCoordinatedEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setGlobalTxId(coordinatedEvent.getGlobalTxId()).setLocalTxId(coordinatedEvent.getLocalTxId()).setParentTxId(coordinatedEvent.getParentTxId()).setMethodName(coordinatedEvent.getMethodName()).setStatus(coordinatedEvent.getStatus().toString()).build();
    }

    private GrpcServiceConfig serviceConfig(String serviceName, String instanceId) {
        return GrpcServiceConfig.newBuilder().setServiceName(serviceName).setInstanceId(instanceId).build();
    }

    private GrpcTccTransactionStartedEvent convertTo(TccStartedEvent tccStartEvent) {
        return GrpcTccTransactionStartedEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setGlobalTxId(tccStartEvent.getGlobalTxId()).setLocalTxId(tccStartEvent.getLocalTxId()).build();
    }

    private GrpcTccTransactionEndedEvent convertTo(TccEndedEvent tccEndEvent) {
        return GrpcTccTransactionEndedEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setGlobalTxId(tccEndEvent.getGlobalTxId()).setLocalTxId(tccEndEvent.getLocalTxId()).setStatus(tccEndEvent.getStatus().toString()).build();
    }

    private GrpcParticipationStartedEvent convertTo(ParticipationStartedEvent participationStartedEvent) {
        return GrpcParticipationStartedEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setGlobalTxId(participationStartedEvent.getGlobalTxId()).setLocalTxId(participationStartedEvent.getLocalTxId()).setParentTxId(participationStartedEvent.getParentTxId()).setConfirmMethod(participationStartedEvent.getConfirmMethod()).setCancelMethod(participationStartedEvent.getCancelMethod()).build();
    }

    private GrpcParticipationEndedEvent convertTo(ParticipationEndedEvent participationEndedEvent) {
        return GrpcParticipationEndedEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setGlobalTxId(participationEndedEvent.getGlobalTxId()).setLocalTxId(participationEndedEvent.getLocalTxId()).setParentTxId(participationEndedEvent.getParentTxId()).setConfirmMethod(participationEndedEvent.getConfirmMethod()).setCancelMethod(participationEndedEvent.getCancelMethod()).setStatus(participationEndedEvent.getStatus().toString()).build();
    }
}

