/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.tcc;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.contract.grpc.GrpcTccCoordinateCommand;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.ReconnectStreamObserver;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcCoordinateStreamObserver
extends ReconnectStreamObserver<GrpcTccCoordinateCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TccMessageHandler messageHandler;

    public GrpcCoordinateStreamObserver(LoadBalanceContext loadBalanceContext, MessageSender messageSender, TccMessageHandler messageHandler) {
        super(loadBalanceContext, messageSender);
        this.messageHandler = messageHandler;
    }

    public void onNext(GrpcTccCoordinateCommand command) {
        LOG.info("Received coordinate command, global tx id: {}, local tx id: {}, call method: {}", new Object[]{command.getGlobalTxId(), command.getLocalTxId(), command.getMethod()});
        this.messageHandler.onReceive(command.getGlobalTxId(), command.getLocalTxId(), command.getParentTxId(), command.getMethod());
    }
}

