/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.saga;

import java.util.concurrent.BlockingQueue;
import org.apache.servicecomb.pack.common.EventType;
import org.apache.servicecomb.pack.contract.grpc.ServerMeta;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.TxEvent;

public class RetryableMessageSender
implements SagaMessageSender {
    private final BlockingQueue<MessageSender> availableMessageSenders;

    public RetryableMessageSender(BlockingQueue<MessageSender> availableMessageSenders) {
        this.availableMessageSenders = availableMessageSenders;
    }

    public void onConnected() {
    }

    public void onDisconnected() {
    }

    public ServerMeta onGetServerMeta() {
        return null;
    }

    public void close() {
    }

    public String target() {
        return "UNKNOWN";
    }

    public AlphaResponse send(TxEvent event) {
        if (event.type() == EventType.SagaStartedEvent) {
            throw new OmegaException("Failed to process subsequent requests because no alpha server is available");
        }
        try {
            return ((SagaMessageSender)this.availableMessageSenders.take()).send(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OmegaException("Failed to send event " + event + " due to interruption", (Throwable)e);
        }
    }
}

