/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.saga;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import org.apache.servicecomb.pack.contract.grpc.GrpcAck;
import org.apache.servicecomb.pack.contract.grpc.GrpcServiceConfig;
import org.apache.servicecomb.pack.contract.grpc.GrpcTxEvent;
import org.apache.servicecomb.pack.contract.grpc.ServerMeta;
import org.apache.servicecomb.pack.contract.grpc.TxEventServiceGrpc;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.saga.GrpcCompensateStreamObserver;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.pack.omega.transaction.MessageHandler;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.MessageSerializer;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.TxEvent;

public class GrpcSagaClientMessageSender
implements SagaMessageSender {
    private final String target;
    private final TxEventServiceGrpc.TxEventServiceStub asyncEventService;
    private final MessageSerializer serializer;
    private final TxEventServiceGrpc.TxEventServiceBlockingStub blockingEventService;
    private final GrpcCompensateStreamObserver compensateStreamObserver;
    private final GrpcServiceConfig serviceConfig;

    public GrpcSagaClientMessageSender(String address, ManagedChannel channel, MessageSerializer serializer, MessageDeserializer deserializer, ServiceConfig serviceConfig, MessageHandler handler, LoadBalanceContext loadContext) {
        this.target = address;
        this.asyncEventService = TxEventServiceGrpc.newStub((Channel)channel);
        this.blockingEventService = TxEventServiceGrpc.newBlockingStub((Channel)channel);
        this.serializer = serializer;
        this.compensateStreamObserver = new GrpcCompensateStreamObserver(loadContext, (MessageSender)this, handler, deserializer);
        this.serviceConfig = this.serviceConfig(serviceConfig.serviceName(), serviceConfig.instanceId());
    }

    public void onConnected() {
        this.asyncEventService.onConnected((StreamObserver)this.compensateStreamObserver).onNext((Object)this.serviceConfig);
    }

    public void onDisconnected() {
        this.blockingEventService.onDisconnected(this.serviceConfig);
    }

    public ServerMeta onGetServerMeta() {
        return this.blockingEventService.onGetServerMeta(this.serviceConfig);
    }

    public void close() {
    }

    public String target() {
        return this.target;
    }

    public AlphaResponse send(TxEvent event) {
        GrpcAck grpcAck = this.blockingEventService.onTxEvent(this.convertEvent(event));
        return new AlphaResponse(grpcAck.getAborted());
    }

    private GrpcTxEvent convertEvent(TxEvent event) {
        ByteString payloads = ByteString.copyFrom((byte[])this.serializer.serialize(event.payloads()));
        GrpcTxEvent.Builder builder = GrpcTxEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setTimestamp(event.timestamp()).setGlobalTxId(event.globalTxId()).setLocalTxId(event.localTxId()).setParentTxId(event.parentTxId() == null ? "" : event.parentTxId()).setType(event.type().name()).setTimeout(event.timeout()).setForwardTimeout(event.forwardTimeout()).setReverseTimeout(event.reverseTimeout()).setCompensationMethod(event.compensationMethod()).setRetryMethod(event.retryMethod() == null ? "" : event.retryMethod()).setForwardRetries(event.forwardRetries()).setReverseRetries(event.reverseRetries()).setRetryDelayInMilliseconds(event.retryDelayInMilliseconds()).setPayloads(payloads);
        return builder.build();
    }

    private GrpcServiceConfig serviceConfig(String serviceName, String instanceId) {
        return GrpcServiceConfig.newBuilder().setServiceName(serviceName).setInstanceId(instanceId).build();
    }
}

