/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.saga;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.contract.grpc.GrpcCompensateCommand;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.ReconnectStreamObserver;
import org.apache.servicecomb.pack.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.pack.omega.transaction.MessageHandler;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcCompensateStreamObserver
extends ReconnectStreamObserver<GrpcCompensateCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageHandler messageHandler;
    private final MessageDeserializer deserializer;

    public GrpcCompensateStreamObserver(LoadBalanceContext loadContext, MessageSender messageSender, MessageHandler messageHandler, MessageDeserializer deserializer) {
        super(loadContext, messageSender);
        this.messageHandler = messageHandler;
        this.deserializer = deserializer;
    }

    public void onNext(GrpcCompensateCommand command) {
        LOG.info("Received compensate command, global tx id: {}, local tx id: {}, compensation method: {}", new Object[]{command.getGlobalTxId(), command.getLocalTxId(), command.getCompensationMethod()});
        this.messageHandler.onReceive(command.getGlobalTxId(), command.getLocalTxId(), command.getParentTxId().isEmpty() ? null : command.getParentTxId(), command.getCompensationMethod(), this.deserializer.deserialize(command.getPayloads().toByteArray()));
    }
}

