/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.core;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PendingTaskRunner {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private final BlockingQueue<Runnable> pendingTasks = new LinkedBlockingQueue<Runnable>();
    private final int reconnectDelay;

    public PendingTaskRunner(int reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ((Runnable)PendingTaskRunner.this.pendingTasks.take()).run();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, 0L, this.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    public BlockingQueue<Runnable> getPendingTasks() {
        return this.pendingTasks;
    }

    public int getReconnectDelay() {
        return this.reconnectDelay;
    }
}

