/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.core;

import com.google.common.base.Optional;
import io.grpc.ManagedChannel;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.contract.grpc.ServerMeta;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.MessageSenderPicker;
import org.apache.servicecomb.pack.omega.connector.grpc.core.SenderExecutor;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadBalanceSenderAdapter
implements MessageSender {
    private final LoadBalanceContext loadContext;
    private final MessageSenderPicker senderPicker;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public LoadBalanceSenderAdapter(LoadBalanceContext loadContext, MessageSenderPicker senderPicker) {
        this.loadContext = loadContext;
        this.senderPicker = senderPicker;
    }

    public <T> T pickMessageSender() {
        return (T)this.senderPicker.pick(this.loadContext.getSenders(), this.loadContext.getGrpcOnErrorHandler().getGrpcRetryContext().getDefaultMessageSender());
    }

    public <T> Optional<AlphaResponse> doGrpcSend(MessageSender messageSender, T event, SenderExecutor<T> executor) {
        AlphaResponse response = null;
        try {
            long startTime = System.nanoTime();
            response = executor.apply(event);
            this.loadContext.getSenders().put(messageSender, System.nanoTime() - startTime);
        }
        catch (OmegaException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Retry sending event {} due to failure", event, (Object)e);
            this.loadContext.getSenders().put(messageSender, Long.MAX_VALUE);
        }
        return Optional.fromNullable((Object)response);
    }

    public void onConnected() {
        for (MessageSender sender : this.loadContext.getSenders().keySet()) {
            try {
                sender.onConnected();
            }
            catch (Exception e) {
                LOG.error("Failed connecting to alpha at {}", (Object)sender.target(), (Object)e);
            }
        }
    }

    public void onDisconnected() {
        for (MessageSender sender : this.loadContext.getSenders().keySet()) {
            try {
                sender.onDisconnected();
            }
            catch (Exception e) {
                LOG.error("Failed disconnecting from alpha at {}", (Object)sender.target(), (Object)e);
            }
        }
    }

    public ServerMeta onGetServerMeta() {
        boolean metaConsistency = true;
        ServerMeta serverMeta = null;
        for (MessageSender sender : this.loadContext.getSenders().keySet()) {
            try {
                if (serverMeta == null) {
                    serverMeta = sender.onGetServerMeta();
                    LOG.info("Alpha configuration is " + serverMeta.getMetaMap());
                } else {
                    ServerMeta otherServerMeta = sender.onGetServerMeta();
                    if (!serverMeta.getMetaMap().equals(otherServerMeta.getMetaMap())) {
                        metaConsistency = false;
                        LOG.warn("Alpha configuration is " + otherServerMeta.getMetaMap());
                    }
                }
                if (metaConsistency) continue;
                throw new Exception("Using different Alpha configuration with multiple Alpha");
            }
            catch (Exception e) {
                LOG.error("Failed disconnecting from alpha at {}", (Object)sender.target(), (Object)e);
            }
        }
        return serverMeta;
    }

    public void close() {
        this.loadContext.getPendingTaskRunner().shutdown();
        for (ManagedChannel channel : this.loadContext.getChannels()) {
            channel.shutdownNow();
        }
    }

    public String target() {
        return "UNKNOWN";
    }

    public MessageSenderPicker getSenderPicker() {
        return this.senderPicker;
    }

    public LoadBalanceContext getLoadContext() {
        return this.loadContext;
    }
}

