/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.spring;

import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.transaction.CallbackContext;
import org.apache.servicecomb.pack.omega.transaction.annotations.Compensable;
import org.apache.servicecomb.pack.omega.transaction.spring.CallbackType;
import org.apache.servicecomb.pack.omega.transaction.spring.MethodCheckingCallback;

class CompensableMethodCheckingCallback
extends MethodCheckingCallback {
    public CompensableMethodCheckingCallback(Object bean, CallbackContext callbackContext) {
        super(bean, callbackContext, CallbackType.Compensation);
    }

    public void doWith(Method method) throws IllegalArgumentException {
        if (!method.isAnnotationPresent(Compensable.class)) {
            return;
        }
        Compensable compensable = method.getAnnotation(Compensable.class);
        String compensationMethod = compensable.compensationMethod();
        if (compensable.forwardRetries() < -1) {
            throw new IllegalArgumentException(String.format("Compensable %s of method %s, the forward retries should not below -1.", compensable, method.getName()));
        }
        this.loadMethodContext(method, compensationMethod);
    }
}

