/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="TxEvent")
public class TxEvent {
    @Transient
    public static final long MAX_TIMESTAMP = 253402214400000L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long surrogateId;
    private String serviceName;
    private String instanceId;
    private Date creationTime;
    private String globalTxId;
    private String localTxId;
    private String parentTxId;
    private String type;
    private String compensationMethod;
    private Date expiryTime;
    private String retryMethod;
    private int retries;
    private byte[] payloads;

    private TxEvent() {
    }

    public TxEvent(TxEvent event) {
        this(event.surrogateId, event.serviceName, event.instanceId, event.creationTime, event.globalTxId, event.localTxId, event.parentTxId, event.type, event.compensationMethod, event.expiryTime, event.retryMethod, event.retries, event.payloads);
    }

    public TxEvent(String serviceName, String instanceId, String globalTxId, String localTxId, String parentTxId, String type, String compensationMethod, byte[] payloads) {
        this(serviceName, instanceId, new Date(), globalTxId, localTxId, parentTxId, type, compensationMethod, 0, "", 0, payloads);
    }

    public TxEvent(String serviceName, String instanceId, String globalTxId, String localTxId, String parentTxId, String type, String compensationMethod, int timeout, String retryMethod, int retries, byte[] payloads) {
        this(null, serviceName, instanceId, new Date(), globalTxId, localTxId, parentTxId, type, compensationMethod, timeout, retryMethod, retries, payloads);
    }

    public TxEvent(String serviceName, String instanceId, Date creationTime, String globalTxId, String localTxId, String parentTxId, String type, String compensationMethod, int timeout, String retryMethod, int retries, byte[] payloads) {
        this(null, serviceName, instanceId, creationTime, globalTxId, localTxId, parentTxId, type, compensationMethod, timeout, retryMethod, retries, payloads);
    }

    TxEvent(Long surrogateId, String serviceName, String instanceId, Date creationTime, String globalTxId, String localTxId, String parentTxId, String type, String compensationMethod, int timeout, String retryMethod, int retries, byte[] payloads) {
        this(surrogateId, serviceName, instanceId, creationTime, globalTxId, localTxId, parentTxId, type, compensationMethod, timeout == 0 ? new Date(253402214400000L) : new Date(creationTime.getTime() + TimeUnit.SECONDS.toMillis(timeout)), retryMethod, retries, payloads);
    }

    TxEvent(Long surrogateId, String serviceName, String instanceId, Date creationTime, String globalTxId, String localTxId, String parentTxId, String type, String compensationMethod, Date expiryTime, String retryMethod, int retries, byte[] payloads) {
        this.surrogateId = surrogateId;
        this.serviceName = serviceName;
        this.instanceId = instanceId;
        this.creationTime = creationTime;
        this.globalTxId = globalTxId;
        this.localTxId = localTxId;
        this.parentTxId = parentTxId;
        this.type = type;
        this.compensationMethod = compensationMethod;
        this.expiryTime = expiryTime;
        this.retryMethod = retryMethod;
        this.retries = retries;
        this.payloads = payloads;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public String globalTxId() {
        return this.globalTxId;
    }

    public String localTxId() {
        return this.localTxId;
    }

    public String parentTxId() {
        return this.parentTxId;
    }

    public String type() {
        return this.type;
    }

    public String compensationMethod() {
        return this.compensationMethod;
    }

    public byte[] payloads() {
        return this.payloads;
    }

    public long id() {
        return this.surrogateId;
    }

    public Date expiryTime() {
        return this.expiryTime;
    }

    public String retryMethod() {
        return this.retryMethod;
    }

    public int retries() {
        return this.retries;
    }

    public String toString() {
        return "TxEvent{surrogateId=" + this.surrogateId + ", serviceName='" + this.serviceName + '\'' + ", instanceId='" + this.instanceId + '\'' + ", creationTime=" + this.creationTime + ", globalTxId='" + this.globalTxId + '\'' + ", localTxId='" + this.localTxId + '\'' + ", parentTxId='" + this.parentTxId + '\'' + ", type='" + this.type + '\'' + ", compensationMethod='" + this.compensationMethod + '\'' + ", expiryTime=" + this.expiryTime + ", retryMethod='" + this.retryMethod + '\'' + ", retries=" + this.retries + '}';
    }
}

