/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import org.apache.servicecomb.pack.alpha.core.TxEvent;
import org.apache.servicecomb.pack.alpha.core.TxEventRepository;
import org.apache.servicecomb.pack.common.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxConsistentService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TxEventRepository eventRepository;
    private final List<String> types = Arrays.asList(EventType.TxStartedEvent.name(), EventType.SagaEndedEvent.name());

    public TxConsistentService(TxEventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }

    public boolean handle(TxEvent event) {
        if (this.types.contains(event.type()) && this.isGlobalTxAborted(event)) {
            LOG.info("Transaction event {} rejected, because its parent with globalTxId {} was already aborted", (Object)event.type(), (Object)event.globalTxId());
            return false;
        }
        this.eventRepository.save(event);
        return true;
    }

    private boolean isGlobalTxAborted(TxEvent event) {
        return !this.eventRepository.findTransactions(event.globalTxId(), EventType.TxAbortedEvent.name()).isEmpty();
    }
}

