/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.servicecomb.pack.alpha.core.AlphaException;
import org.apache.servicecomb.pack.alpha.core.OmegaCallback;
import org.apache.servicecomb.pack.alpha.core.TxEvent;
import org.apache.servicecomb.pack.alpha.core.exception.CompensateAckFailedException;
import org.apache.servicecomb.pack.alpha.core.exception.CompensateConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeOmegaCallback
implements OmegaCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Map<String, OmegaCallback>> callbacks;

    public CompositeOmegaCallback(Map<String, Map<String, OmegaCallback>> callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public void compensate(TxEvent event) {
        Map serviceCallbacks = this.callbacks.getOrDefault(event.serviceName(), Collections.emptyMap());
        OmegaCallback omegaCallback = (OmegaCallback)serviceCallbacks.get(event.instanceId());
        if (omegaCallback == null) {
            LOG.info("Cannot find the service with the instanceId {}, call the other instance.", (Object)event.instanceId());
            Iterator iterator = new ArrayList(serviceCallbacks.values()).iterator();
            if (iterator.hasNext()) {
                omegaCallback = (OmegaCallback)iterator.next();
            }
        }
        if (omegaCallback == null) {
            throw new AlphaException("No such omega callback found for service " + event.serviceName());
        }
        try {
            omegaCallback.compensate(event);
        }
        catch (CompensateConnectException e) {
            serviceCallbacks.values().remove(omegaCallback);
            throw e;
        }
        catch (CompensateAckFailedException e) {
            throw e;
        }
        catch (Exception e) {
            serviceCallbacks.values().remove(omegaCallback);
            throw e;
        }
    }
}

