/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.context;

import org.apache.servicecomb.pack.omega.context.AlphaMetas;
import org.apache.servicecomb.pack.omega.context.IdGenerator;
import org.apache.servicecomb.pack.omega.context.TransactionContext;

public class OmegaContext {
    public static final String GLOBAL_TX_ID_KEY = "X-Pack-Global-Transaction-Id";
    public static final String LOCAL_TX_ID_KEY = "X-Pack-Local-Transaction-Id";
    private final ThreadLocal<String> globalTxId = new InheritableThreadLocal<String>();
    private final ThreadLocal<String> localTxId = new InheritableThreadLocal<String>();
    private final IdGenerator<String> idGenerator;
    private final AlphaMetas alphaMetas;

    public OmegaContext(IdGenerator<String> idGenerator) {
        this(idGenerator, AlphaMetas.builder().akkaEnabled(false).build());
    }

    public OmegaContext(IdGenerator<String> idGenerator, AlphaMetas alphaMetas) {
        this.idGenerator = idGenerator;
        this.alphaMetas = alphaMetas;
    }

    public String newGlobalTxId() {
        String id = this.idGenerator.nextId();
        this.globalTxId.set(id);
        return id;
    }

    public void setGlobalTxId(String txId) {
        this.globalTxId.set(txId);
    }

    public String globalTxId() {
        return this.globalTxId.get();
    }

    public String newLocalTxId() {
        String id = this.idGenerator.nextId();
        this.localTxId.set(id);
        return id;
    }

    public void setLocalTxId(String localTxId) {
        this.localTxId.set(localTxId);
    }

    public String localTxId() {
        return this.localTxId.get();
    }

    public AlphaMetas getAlphaMetas() {
        return this.alphaMetas;
    }

    public TransactionContext getTransactionContext() {
        return new TransactionContext(this.globalTxId(), this.localTxId());
    }

    public void clear() {
        this.globalTxId.remove();
        this.localTxId.remove();
    }

    public String toString() {
        return "OmegaContext{globalTxId=" + this.globalTxId.get() + ", localTxId=" + this.localTxId.get() + ", " + this.alphaMetas + '}';
    }

    public void verify() {
        if (this.globalTxId == null) {
            throw new RuntimeException("OmegaContext globalTxId is empty, Please check if you setup the pack transport handler rightly");
        }
    }
}

