/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transport.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignClientRequestInterceptor
implements RequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext omegaContext;

    public FeignClientRequestInterceptor(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public void apply(RequestTemplate input) {
        if (this.omegaContext != null && this.omegaContext.globalTxId() != null) {
            input.header("X-Pack-Global-Transaction-Id", new String[]{this.omegaContext.globalTxId()});
            input.header("X-Pack-Local-Transaction-Id", new String[]{this.omegaContext.localTxId()});
            LOG.debug("Added {} {} and {} {} to request header", new Object[]{"X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId(), "X-Pack-Local-Transaction-Id", this.omegaContext.localTxId()});
        } else {
            LOG.debug("Cannot inject transaction ID, as the OmegaContext is null or cannot get the globalTxId.");
        }
    }
}

