/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.wrapper;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.nio.channels.ClosedByInterruptException;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.annotations.SagaStart;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.SagaStartAnnotationProcessor;
import org.apache.servicecomb.pack.omega.transaction.TransactionTimeoutException;
import org.apache.servicecomb.pack.omega.transaction.wrapper.TimeoutProb;
import org.apache.servicecomb.pack.omega.transaction.wrapper.TimeoutProbManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaStartAnnotationProcessorTimeoutWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SagaStartAnnotationProcessor sagaStartAnnotationProcessor;

    public SagaStartAnnotationProcessorTimeoutWrapper(SagaStartAnnotationProcessor sagaStartAnnotationProcessor) {
        this.sagaStartAnnotationProcessor = sagaStartAnnotationProcessor;
    }

    public Object apply(ProceedingJoinPoint joinPoint, SagaStart sagaStart, OmegaContext context) throws Throwable {
        TimeoutProb timeoutProb = TimeoutProbManager.getInstance().addTimeoutProb(sagaStart.timeout());
        try {
            Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
            this.sagaStartAnnotationProcessor.preIntercept(sagaStart.timeout());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized context {} before execution of method {}", (Object)context, (Object)method.toString());
            }
            try {
                Object output = joinPoint.proceed();
                if (timeoutProb.getInterruptFailureException() != null) {
                    throw new OmegaException(timeoutProb.getInterruptFailureException());
                }
                if (sagaStart.autoClose()) {
                    this.sagaStartAnnotationProcessor.postIntercept(context.globalTxId());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Transaction with context {} has finished.", (Object)context);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction with context {} is not finished in the SagaStarted annotated method.", (Object)context);
                }
                Object object = output;
                return object;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("TimeoutWrapper exception {}", (Object)throwable.getClass().getName());
                }
                if (timeoutProb.getInterruptFailureException() != null) {
                    LOG.info("TimeoutProb interrupt fail");
                    throw timeoutProb.getInterruptFailureException();
                }
                if (this.isThreadInterruptException(throwable)) {
                    throw new TransactionTimeoutException("Timeout interrupt", throwable);
                }
                if (!(throwable instanceof OmegaException)) {
                    LOG.info("TimeoutWrapper Exception {}", (Object)throwable.getClass().getName());
                    this.sagaStartAnnotationProcessor.onError(method.toString(), throwable);
                    LOG.error("Transaction {} failed.", (Object)context.globalTxId());
                }
                throw throwable;
            }
        }
        finally {
            context.clear();
            TimeoutProbManager.getInstance().removeTimeoutProb(timeoutProb);
        }
    }

    private boolean isThreadInterruptException(Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof IllegalMonitorStateException || throwable instanceof ClosedByInterruptException || throwable.getCause() instanceof InterruptedException || throwable.getCause() instanceof IllegalMonitorStateException || throwable.getCause() instanceof ClosedByInterruptException;
    }
}

