/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.tcc;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.annotations.TccStart;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccStartAnnotationProcessor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TccStartAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final TccStartAnnotationProcessor tccStartAnnotationProcessor;
    private final OmegaContext context;

    public TccStartAspect(TccMessageSender tccMessageSender, OmegaContext context) {
        this.context = context;
        this.tccStartAnnotationProcessor = new TccStartAnnotationProcessor(context, tccMessageSender);
    }

    @Around(value="execution(@org.apache.servicecomb.pack.omega.context.annotations.TccStart * *(..)) && @annotation(tccStart)")
    Object advise(ProceedingJoinPoint joinPoint, TccStart tccStart) throws Throwable {
        this.initializeOmegaContext();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        this.tccStartAnnotationProcessor.preIntercept(this.context.globalTxId(), method.toString(), tccStart.timeout());
        LOG.debug("Initialized context {} before execution of method {}", (Object)this.context, (Object)method.toString());
        try {
            Object result = joinPoint.proceed();
            this.tccStartAnnotationProcessor.postIntercept(this.context.globalTxId(), method.toString());
            LOG.debug("Transaction with context {} has finished.", (Object)this.context);
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OmegaException)) {
                this.tccStartAnnotationProcessor.onError(this.context.globalTxId(), method.toString(), throwable);
                LOG.error("Transaction {} failed.", (Object)this.context.globalTxId());
            }
            throw throwable;
        }
        finally {
            this.context.clear();
        }
    }

    private void initializeOmegaContext() {
        this.context.setLocalTxId(this.context.newGlobalTxId());
    }
}

