/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.tcc;

import javax.transaction.TransactionalException;
import org.apache.servicecomb.pack.common.TransactionStatus;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.TccEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.TccStartedEvent;

public class TccStartAnnotationProcessor {
    private final OmegaContext omegaContext;
    private final TccMessageSender tccMessageSender;

    TccStartAnnotationProcessor(OmegaContext omegaContext, TccMessageSender tccMessageSender) {
        this.omegaContext = omegaContext;
        this.tccMessageSender = tccMessageSender;
    }

    public AlphaResponse preIntercept(String parentTxId, String methodName, int timeout) {
        try {
            return this.tccMessageSender.tccTransactionStart(new TccStartedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId()));
        }
        catch (OmegaException e) {
            throw new TransactionalException(e.getMessage(), e.getCause());
        }
    }

    public void postIntercept(String parentTxId, String methodName) {
        this.tccMessageSender.tccTransactionStop(new TccEndedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), TransactionStatus.Succeed));
    }

    public void onError(String parentTxId, String methodName, Throwable throwable) {
        this.tccMessageSender.tccTransactionStop(new TccEndedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), TransactionStatus.Failed));
    }
}

