/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction.tcc;

import org.apache.servicecomb.pack.common.TransactionStatus;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.CallbackContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.ParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageHandler;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.apache.servicecomb.pack.omega.transaction.tcc.events.CoordinatedEvent;

public class CoordinateMessageHandler
implements TccMessageHandler {
    private final TccMessageSender tccMessageSender;
    private final CallbackContext callbackContext;
    private final OmegaContext omegaContext;
    private final ParametersContext parametersContext;

    public CoordinateMessageHandler(TccMessageSender tccMessageSender, CallbackContext callbackContext, OmegaContext omegaContext, ParametersContext parametersContext) {
        this.tccMessageSender = tccMessageSender;
        this.callbackContext = callbackContext;
        this.omegaContext = omegaContext;
        this.parametersContext = parametersContext;
    }

    @Override
    public void onReceive(String globalTxId, String localTxId, String parentTxId, String methodName) {
        this.callbackContext.apply(globalTxId, localTxId, parentTxId, methodName, this.parametersContext.getParameters(localTxId));
        this.tccMessageSender.coordinate(new CoordinatedEvent(globalTxId, localTxId, parentTxId, methodName, TransactionStatus.Succeed));
        this.parametersContext.removeParameter(localTxId);
    }
}

