/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.servicecomb.pack.common.Environment;
import org.apache.servicecomb.pack.common.EventType;

public class TxEvent {
    private final long timestamp = System.currentTimeMillis();
    private final EventType type;
    private final String globalTxId;
    private final String localTxId;
    private final String parentTxId;
    private final String compensationMethod;
    private final int timeout;
    private final Object[] payloads;
    private final String retryMethod;
    private final int forwardRetries;
    private final int forwardTimeout;
    private final int reverseRetries;
    private final int reverseTimeout;
    private final int retryDelayInMilliseconds;

    public TxEvent(EventType type, String globalTxId, String localTxId, String parentTxId, String compensationMethod, int timeout, String retryMethod, int forwardRetries, int forwardTimeout, int reverseRetries, int reverseTimeout, int retryDelayInMilliseconds, Object ... payloads) {
        this.type = type;
        this.globalTxId = globalTxId;
        this.localTxId = localTxId;
        this.parentTxId = parentTxId;
        this.compensationMethod = compensationMethod;
        this.timeout = timeout;
        this.retryMethod = retryMethod;
        this.forwardRetries = forwardRetries;
        this.forwardTimeout = forwardTimeout;
        this.reverseRetries = reverseRetries;
        this.reverseTimeout = reverseTimeout;
        this.retryDelayInMilliseconds = retryDelayInMilliseconds;
        this.payloads = payloads;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public String globalTxId() {
        return this.globalTxId;
    }

    public String localTxId() {
        return this.localTxId;
    }

    public String parentTxId() {
        return this.parentTxId;
    }

    public Object[] payloads() {
        return this.payloads;
    }

    public EventType type() {
        return this.type;
    }

    public String compensationMethod() {
        return this.compensationMethod;
    }

    public int timeout() {
        return this.timeout;
    }

    public String retryMethod() {
        return this.retryMethod;
    }

    public int forwardRetries() {
        return this.forwardRetries;
    }

    public int forwardTimeout() {
        return this.forwardTimeout;
    }

    public int reverseRetries() {
        return this.reverseRetries;
    }

    public int reverseTimeout() {
        return this.reverseTimeout;
    }

    public int retryDelayInMilliseconds() {
        return this.retryDelayInMilliseconds;
    }

    public String toString() {
        return this.type.name() + "{globalTxId='" + this.globalTxId + '\'' + ", localTxId='" + this.localTxId + '\'' + ", parentTxId='" + this.parentTxId + '\'' + ", compensationMethod='" + this.compensationMethod + '\'' + ", timeout=" + this.timeout + '\'' + ", retryMethod='" + this.retryMethod + '\'' + ", forwardRetries=" + this.forwardRetries + '\'' + ", forwardTimeout=" + this.forwardTimeout + '\'' + ", reverseRetries=" + this.reverseRetries + '\'' + ", reverseTimeout=" + this.reverseTimeout + '\'' + ", payloads=" + Arrays.toString(this.payloads) + '}';
    }

    protected static String stackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString();
        if (stackTrace.length() > Environment.getInstance().getPayloadsMaxLength()) {
            stackTrace = stackTrace.substring(0, Environment.getInstance().getPayloadsMaxLength());
        }
        return stackTrace;
    }
}

