/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.TransactionContext;
import org.apache.servicecomb.pack.omega.context.TransactionContextProperties;
import org.slf4j.Logger;

public abstract class TransactionContextHelper {
    protected TransactionContext extractTransactionContext(Object[] args) {
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof TransactionContext) {
                    return (TransactionContext)arg;
                }
                if (!(arg instanceof TransactionContextProperties)) continue;
                TransactionContextProperties transactionContextProperties = (TransactionContextProperties)arg;
                return new TransactionContext(transactionContextProperties.getGlobalTxId(), transactionContextProperties.getLocalTxId());
            }
        }
        return null;
    }

    protected void populateOmegaContext(OmegaContext context, TransactionContext transactionContext) {
        if (context.globalTxId() != null) {
            this.getLogger().warn("The context {}'s globalTxId is not empty. Update it for globalTxId:{} and localTxId:{}", new Object[]{context, transactionContext.globalTxId(), transactionContext.localTxId()});
        } else {
            this.getLogger().debug("Updated context {} for globalTxId:{} and localTxId:{}", new Object[]{context, transactionContext.globalTxId(), transactionContext.localTxId()});
        }
        context.setGlobalTxId(transactionContext.globalTxId());
        context.setLocalTxId(transactionContext.localTxId());
    }

    protected abstract Logger getLogger();
}

