/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.annotations.SagaEnd;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;
import org.apache.servicecomb.pack.omega.transaction.SagaAbortedEvent;
import org.apache.servicecomb.pack.omega.transaction.SagaEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=300)
public class SagaEndAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OmegaContext context;
    private final SagaMessageSender sender;

    public SagaEndAspect(SagaMessageSender sender, OmegaContext context) {
        this.sender = sender;
        this.context = context;
    }

    @Around(value="execution(@org.apache.servicecomb.pack.omega.context.annotations.SagaEnded * *(..)) && @annotation(sagaEnd)")
    Object advise(ProceedingJoinPoint joinPoint, SagaEnd sagaEnd) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        try {
            Object result = joinPoint.proceed();
            this.sendSagaEndedEvent();
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OmegaException)) {
                LOG.error("Transaction {} failed.", (Object)this.context.globalTxId());
                this.sendSagaAbortedEvent(method.toString(), throwable);
            }
            throw throwable;
        }
        finally {
            this.context.clear();
        }
    }

    private void sendSagaEndedEvent() {
        this.sender.send(new SagaEndedEvent(this.context.globalTxId(), this.context.localTxId()));
    }

    private void sendSagaAbortedEvent(String methodName, Throwable throwable) {
        this.sender.send(new SagaAbortedEvent(this.context.globalTxId(), this.context.localTxId(), null, methodName, throwable));
    }
}

