/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.AbstractRecoveryPolicy;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.CompensableInterceptor;
import org.apache.servicecomb.pack.omega.transaction.annotations.Compensable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRecovery
extends AbstractRecoveryPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public Object applyTo(ProceedingJoinPoint joinPoint, Compensable compensable, CompensableInterceptor interceptor, OmegaContext context, String parentTxId, int forwardRetries) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        LOG.debug("Intercepting compensable method {} with context {}", (Object)method.toString(), (Object)context);
        String compensationSignature = compensable.compensationMethod().isEmpty() ? "" : this.compensationMethodSignature(joinPoint, compensable, method);
        String retrySignature = forwardRetries != 0 || compensationSignature.isEmpty() ? method.toString() : "";
        AlphaResponse response = interceptor.preIntercept(parentTxId, compensationSignature, compensable.forwardTimeout(), retrySignature, forwardRetries, compensable.forwardTimeout(), compensable.reverseRetries(), compensable.reverseTimeout(), compensable.retryDelayInMilliseconds(), joinPoint.getArgs());
        if (response.aborted()) {
            String abortedLocalTxId = context.localTxId();
            context.setLocalTxId(parentTxId);
            throw new InvalidTransactionException("Abort sub transaction " + abortedLocalTxId + " because global transaction " + context.globalTxId() + " has already aborted.");
        }
        try {
            Object result = joinPoint.proceed();
            interceptor.postIntercept(parentTxId, compensationSignature);
            return result;
        }
        catch (Throwable throwable) {
            if (compensable.forwardRetries() == 0 || compensable.forwardRetries() > 0 && forwardRetries == 1) {
                interceptor.onError(parentTxId, compensationSignature, throwable);
            }
            throw throwable;
        }
    }

    String compensationMethodSignature(ProceedingJoinPoint joinPoint, Compensable compensable, Method method) throws NoSuchMethodException {
        return joinPoint.getTarget().getClass().getDeclaredMethod(compensable.compensationMethod(), method.getParameterTypes()).toString();
    }
}

