/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.AlphaResponse;
import org.apache.servicecomb.pack.omega.transaction.EventAwareInterceptor;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.TxAbortedEvent;
import org.apache.servicecomb.pack.omega.transaction.TxEndedEvent;
import org.apache.servicecomb.pack.omega.transaction.TxStartedEvent;

public class CompensableInterceptor
implements EventAwareInterceptor {
    private final OmegaContext context;
    private final SagaMessageSender sender;

    CompensableInterceptor(OmegaContext context, SagaMessageSender sender) {
        this.sender = sender;
        this.context = context;
    }

    @Override
    public AlphaResponse preIntercept(String parentTxId, String compensationMethod, int timeout, String retriesMethod, int forwardRetries, int forwardTimeout, int reverseRetries, int reverseTimeout, int retryDelayInMilliseconds, Object ... message) {
        return this.sender.send(new TxStartedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod, timeout, retriesMethod, forwardRetries, forwardTimeout, reverseRetries, reverseTimeout, retryDelayInMilliseconds, message));
    }

    @Override
    public void postIntercept(String parentTxId, String compensationMethod) {
        this.sender.send(new TxEndedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod));
    }

    @Override
    public void onError(String parentTxId, String compensationMethod, Throwable throwable) {
        this.sender.send(new TxAbortedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod, throwable));
    }
}

