/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transaction.SagaMessageSender;
import org.apache.servicecomb.pack.omega.transaction.TxCompensateAckFailedEvent;
import org.apache.servicecomb.pack.omega.transaction.TxCompensateAckSucceedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackContext {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, CallbackContextInternal> contexts = new ConcurrentHashMap<String, CallbackContextInternal>();
    private final OmegaContext omegaContext;
    private final SagaMessageSender sender;

    public CallbackContext(OmegaContext omegaContext, SagaMessageSender sender) {
        this.omegaContext = omegaContext;
        this.sender = sender;
    }

    public void addCallbackContext(String key, Method compensationMethod, Object target) {
        compensationMethod.setAccessible(true);
        this.contexts.put(key, new CallbackContextInternal(target, compensationMethod));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(String globalTxId, String localTxId, String parentTxId, String callbackMethod, Object ... payloads) {
        block9: {
            String oldGlobalTxId = this.omegaContext.globalTxId();
            String oldLocalTxId = this.omegaContext.localTxId();
            try {
                this.omegaContext.setGlobalTxId(globalTxId);
                this.omegaContext.setLocalTxId(localTxId);
                if (this.contexts.containsKey(callbackMethod)) {
                    CallbackContextInternal contextInternal = this.contexts.get(callbackMethod);
                    contextInternal.callbackMethod.invoke(contextInternal.target, payloads);
                    if (this.omegaContext.getAlphaMetas().isAkkaEnabled()) {
                        this.sender.send(new TxCompensateAckSucceedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), parentTxId, callbackMethod));
                    }
                    LOG.info("Callback transaction with global tx id [{}], local tx id [{}]", (Object)globalTxId, (Object)localTxId);
                    break block9;
                }
                if (this.omegaContext.getAlphaMetas().isAkkaEnabled()) {
                    String msg = "callback method " + callbackMethod + " not found on CallbackContext, If it is starting, please try again later";
                    this.sender.send(new TxCompensateAckFailedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), parentTxId, callbackMethod, new Exception(msg)));
                    LOG.error(msg);
                    break block9;
                }
                throw new NullPointerException();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (this.omegaContext.getAlphaMetas().isAkkaEnabled()) {
                    this.sender.send(new TxCompensateAckFailedEvent(this.omegaContext.globalTxId(), this.omegaContext.localTxId(), parentTxId, callbackMethod, e));
                }
                LOG.error("Pre-checking for callback method " + callbackMethod + " was somehow skipped, did you forget to configure callback method checking on service startup?", (Throwable)e);
            }
            finally {
                this.omegaContext.setGlobalTxId(oldGlobalTxId);
                this.omegaContext.setLocalTxId(oldLocalTxId);
            }
        }
    }

    public OmegaContext getOmegaContext() {
        return this.omegaContext;
    }

    private static final class CallbackContextInternal {
        private final Object target;
        private final Method callbackMethod;

        private CallbackContextInternal(Object target, Method callbackMethod) {
            this.target = target;
            this.callbackMethod = callbackMethod;
        }
    }
}

