/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.common.serialize.java;

import com.alibaba.dubbo.common.serialize.java.CompactedObjectInputStream;
import com.alibaba.dubbo.common.serialize.nativejava.NativeJavaObjectInput;
import com.alibaba.dubbo.common.utils.SerialDetector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;

public class JavaObjectInput
extends NativeJavaObjectInput {
    public static final int MAX_BYTE_ARRAY_LENGTH = 0x800000;

    public JavaObjectInput(InputStream is) throws IOException {
        super(new SerialDetector(is));
    }

    public JavaObjectInput(InputStream is, boolean compacted) throws IOException {
        super(compacted ? new CompactedObjectInputStream(is) : new SerialDetector(is));
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len = this.getObjectInputStream().readInt();
        if (len < 0) {
            return null;
        }
        if (len == 0) {
            return new byte[0];
        }
        if (len > 0x800000) {
            throw new IOException("Byte array length too large. " + len);
        }
        byte[] b = new byte[len];
        this.getObjectInputStream().readFully(b);
        return b;
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.getObjectInputStream().readInt();
        if (len < 0) {
            return null;
        }
        return this.getObjectInputStream().readUTF();
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        byte b = this.getObjectInputStream().readByte();
        if (b == 0) {
            return null;
        }
        return this.getObjectInputStream().readObject();
    }

    @Override
    public <T> T readObject(Class<T> cls) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }

    @Override
    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        return (T)this.readObject();
    }
}

