/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core.metrics;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsBean {
    private AtomicLong eventReceived = new AtomicLong();
    private AtomicLong eventAccepted = new AtomicLong();
    private AtomicLong eventRejected = new AtomicLong();
    private AtomicDouble eventAvgTime = new AtomicDouble();
    private AtomicLong actorReceived = new AtomicLong();
    private AtomicLong actorAccepted = new AtomicLong();
    private AtomicLong actorRejected = new AtomicLong();
    private AtomicDouble actorAvgTime = new AtomicDouble();
    private AtomicLong sagaBeginCounter = new AtomicLong();
    private AtomicLong sagaEndCounter = new AtomicLong();
    private AtomicDouble sagaAvgTime = new AtomicDouble();
    private AtomicLong committed = new AtomicLong();
    private AtomicLong compensated = new AtomicLong();
    private AtomicLong suspended = new AtomicLong();
    private AtomicLong repositoryReceived = new AtomicLong();
    private AtomicLong repositoryAccepted = new AtomicLong();
    private AtomicLong repositoryRejected = new AtomicLong();
    private AtomicDouble repositoryAvgTime = new AtomicDouble();

    public void doEventReceived() {
        this.eventReceived.incrementAndGet();
    }

    public void doEventAccepted() {
        this.eventAccepted.incrementAndGet();
    }

    public void doEventRejected() {
        this.eventRejected.incrementAndGet();
    }

    public void doEventAvgTime(long time) {
        if (this.eventAvgTime.get() == 0.0) {
            this.eventAvgTime.set((double)time);
        } else {
            this.eventAvgTime.set((this.eventAvgTime.get() + (double)time) / 2.0);
        }
    }

    public void doActorReceived() {
        this.actorReceived.incrementAndGet();
    }

    public void doActorAccepted() {
        this.actorAccepted.incrementAndGet();
    }

    public void doActorRejected() {
        this.actorRejected.incrementAndGet();
    }

    public void doActorAvgTime(long time) {
        if (this.actorAvgTime.get() == 0.0) {
            this.actorAvgTime.set((double)time);
        } else {
            this.actorAvgTime.set((this.actorAvgTime.get() + (double)time) / 2.0);
        }
    }

    public void doSagaBeginCounter() {
        this.sagaBeginCounter.incrementAndGet();
    }

    public void doSagaEndCounter() {
        this.sagaEndCounter.incrementAndGet();
    }

    public void doSagaAvgTime(long time) {
        if (this.sagaAvgTime.get() == 0.0) {
            this.sagaAvgTime.set((double)time);
        } else {
            this.sagaAvgTime.set((this.sagaAvgTime.get() + (double)time) / 2.0);
        }
    }

    public void doCommitted() {
        this.committed.incrementAndGet();
    }

    public void doCompensated() {
        this.compensated.incrementAndGet();
    }

    public void doSuspended() {
        this.suspended.incrementAndGet();
    }

    public void doRepositoryReceived() {
        this.repositoryReceived.incrementAndGet();
    }

    public void doRepositoryAccepted() {
        this.repositoryAccepted.incrementAndGet();
    }

    public void doRepositoryAccepted(int size) {
        this.repositoryAccepted.getAndAdd(size);
    }

    public void doRepositoryRejected() {
        this.repositoryRejected.incrementAndGet();
    }

    public void doRepositoryAvgTime(long time) {
        if (this.repositoryAvgTime.get() == 0.0) {
            this.repositoryAvgTime.set((double)time);
        } else {
            this.repositoryAvgTime.set((this.repositoryAvgTime.get() + (double)time) / 2.0);
        }
    }

    public long getEventReceived() {
        return this.eventReceived.get();
    }

    public long getEventAccepted() {
        return this.eventAccepted.get();
    }

    public long getEventRejected() {
        return this.eventRejected.get();
    }

    public double getEventAvgTime() {
        return (double)Math.round(this.eventAvgTime.get() * 100.0) / 100.0;
    }

    public long getActorReceived() {
        return this.actorReceived.get();
    }

    public long getActorAccepted() {
        return this.actorAccepted.get();
    }

    public long getActorRejected() {
        return this.actorRejected.get();
    }

    public double getActorAvgTime() {
        return (double)Math.round(this.actorAvgTime.get() * 100.0) / 100.0;
    }

    public long getSagaBeginCounter() {
        return this.sagaBeginCounter.get();
    }

    public long getSagaEndCounter() {
        return this.sagaEndCounter.get();
    }

    public double getSagaAvgTime() {
        return (double)Math.round(this.sagaAvgTime.get() * 100.0) / 100.0;
    }

    public long getRepositoryReceived() {
        return this.repositoryReceived.get();
    }

    public long getRepositoryAccepted() {
        return this.repositoryAccepted.get();
    }

    public long getRepositoryRejected() {
        return this.repositoryRejected.get();
    }

    public double getRepositoryAvgTime() {
        return (double)Math.round(this.repositoryAvgTime.get() * 100.0) / 100.0;
    }

    public long getCommitted() {
        return this.committed.get();
    }

    public long getCompensated() {
        return this.compensated.get();
    }

    public long getSuspended() {
        return this.suspended.get();
    }
}

