/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core.fsm.repository.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.apache.servicecomb.pack.alpha.core.fsm.TxState;

public class SagaSubTransaction {
    private String localTxId;
    private String parentTxId;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private Date beginTime;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private Date endTime;
    private TxState state;
    private Long durationTime;

    public String getLocalTxId() {
        return this.localTxId;
    }

    public String getParentTxId() {
        return this.parentTxId;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public TxState getState() {
        return this.state;
    }

    public Long getDurationTime() {
        return this.durationTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String localTxId;
        private String parentTxId;
        private Date beginTime;
        private Date endTime;
        private TxState state;

        private Builder() {
        }

        public Builder localTxId(String localTxId) {
            this.localTxId = localTxId;
            return this;
        }

        public Builder parentTxId(String parentTxId) {
            this.parentTxId = parentTxId;
            return this;
        }

        public Builder beginTime(Date beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder state(TxState state) {
            this.state = state;
            return this;
        }

        public SagaSubTransaction build() {
            SagaSubTransaction sagaSubTransaction = new SagaSubTransaction();
            sagaSubTransaction.parentTxId = this.parentTxId;
            sagaSubTransaction.beginTime = this.beginTime;
            sagaSubTransaction.state = this.state;
            sagaSubTransaction.durationTime = this.endTime.getTime() - this.beginTime.getTime();
            sagaSubTransaction.localTxId = this.localTxId;
            sagaSubTransaction.endTime = this.endTime;
            return sagaSubTransaction;
        }
    }
}

