/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core.fsm.repository.model;

import java.util.List;
import org.apache.servicecomb.pack.alpha.core.fsm.repository.model.GlobalTransaction;

public class PagingGlobalTransactions {
    private long total;
    private int page;
    private int size;
    private long elapsed;
    private List<GlobalTransaction> globalTransactions;

    public long getTotal() {
        return this.total;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public List<GlobalTransaction> getGlobalTransactions() {
        return this.globalTransactions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private long total;
        private int page;
        private int size;
        private long elapsed;
        private List<GlobalTransaction> globalTransactions;

        private Builder() {
        }

        public Builder total(long total) {
            this.total = total;
            return this;
        }

        public Builder page(int page) {
            this.page = page;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder elapsed(long elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public Builder globalTransactions(List<GlobalTransaction> globalTransactions) {
            this.globalTransactions = globalTransactions;
            return this;
        }

        public PagingGlobalTransactions build() {
            PagingGlobalTransactions pagingGlobalTransactions = new PagingGlobalTransactions();
            pagingGlobalTransactions.total = this.total;
            pagingGlobalTransactions.globalTransactions = this.globalTransactions;
            pagingGlobalTransactions.page = this.page;
            pagingGlobalTransactions.size = this.size;
            pagingGlobalTransactions.elapsed = this.elapsed;
            return pagingGlobalTransactions;
        }
    }
}

