/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.alpha.core;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PendingTaskRunner {
    private final BlockingQueue<Runnable> pendingTasks;
    private final int delay;

    public PendingTaskRunner(BlockingQueue<Runnable> pendingTasks, int delay) {
        this.pendingTasks = pendingTasks;
        this.delay = delay;
    }

    public Future<?> run() {
        return Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(() -> {
            try {
                this.pendingTasks.take().run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, 0L, this.delay, TimeUnit.MILLISECONDS);
    }
}

