/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.spring;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.pack.omega.connector.grpc.core.FastestSender;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContextBuilder;
import org.apache.servicecomb.pack.omega.connector.grpc.core.MessageSenderPicker;
import org.apache.servicecomb.pack.omega.connector.grpc.core.TransactionType;
import org.apache.servicecomb.pack.omega.connector.grpc.tcc.TccLoadBalanceSender;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.transaction.CallbackContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.DefaultParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.ParametersContext;
import org.apache.servicecomb.pack.omega.transaction.tcc.TccMessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${omega.spec.names}'.contains('tcc')")
class OmegaTccSpringConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public OmegaTccSpringConfig() {
        LOG.info("Omega Specification TCC");
    }

    @Bean
    ParametersContext parametersContext() {
        return new DefaultParametersContext();
    }

    @Bean(name={"coordinateContext"})
    CallbackContext coordinateContext(OmegaContext omegaContext) {
        return new CallbackContext(omegaContext, null);
    }

    @Bean(name={"tccLoadContext"})
    LoadBalanceContext loadBalanceSenderContext(AlphaClusterConfig alphaClusterConfig, ServiceConfig serviceConfig, @Value(value="${omega.connection.reconnectDelay:3000}") int reconnectDelay, @Value(value="${omega.connection.sending.timeout:8}") int timeoutSeconds) {
        LoadBalanceContext loadBalanceSenderContext = new LoadBalanceContextBuilder(TransactionType.TCC, alphaClusterConfig, serviceConfig, reconnectDelay, timeoutSeconds).build();
        return loadBalanceSenderContext;
    }

    @Bean
    TccMessageSender tccLoadBalanceSender(@Qualifier(value="tccLoadContext") LoadBalanceContext loadBalanceSenderContext) {
        TccLoadBalanceSender tccMessageSender = new TccLoadBalanceSender(loadBalanceSenderContext, (MessageSenderPicker)new FastestSender());
        tccMessageSender.onConnected();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable((TccMessageSender)tccMessageSender){
            final /* synthetic */ TccMessageSender val$tccMessageSender;
            {
                this.val$tccMessageSender = tccMessageSender;
            }

            @Override
            public void run() {
                this.val$tccMessageSender.onDisconnected();
                this.val$tccMessageSender.close();
            }
        }));
        return tccMessageSender;
    }
}

