/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.core;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBackReconnectRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageSender messageSender;
    private final Map<MessageSender, Long> senders;
    private final BlockingQueue<Runnable> pendingTasks;
    private final BlockingQueue<MessageSender> connectedSenders;

    public PushBackReconnectRunnable(MessageSender messageSender, Map<MessageSender, Long> senders, BlockingQueue<Runnable> pendingTasks, BlockingQueue<MessageSender> connectedSenders) {
        this.messageSender = messageSender;
        this.senders = senders;
        this.pendingTasks = pendingTasks;
        this.connectedSenders = connectedSenders;
    }

    @Override
    public void run() {
        try {
            LOG.info("Retry connecting to alpha at {}", (Object)this.messageSender.target());
            this.messageSender.onDisconnected();
            this.messageSender.onConnected();
            this.senders.put(this.messageSender, 0L);
            this.connectedSenders.offer(this.messageSender);
            LOG.info("Retry connecting to alpha at {} is successful", (Object)this.messageSender.target());
        }
        catch (Exception e) {
            LOG.error("Failed to reconnect to alpha at {}", (Object)this.messageSender.target(), (Object)e);
            this.pendingTasks.offer(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushBackReconnectRunnable that = (PushBackReconnectRunnable)o;
        return Objects.equals(this.messageSender, that.messageSender);
    }

    public int hashCode() {
        return Objects.hash(this.messageSender);
    }
}

