/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.core;

import com.google.common.base.Optional;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import org.apache.servicecomb.pack.omega.connector.grpc.AlphaClusterConfig;
import org.apache.servicecomb.pack.omega.connector.grpc.core.LoadBalanceContext;
import org.apache.servicecomb.pack.omega.connector.grpc.core.TransactionType;
import org.apache.servicecomb.pack.omega.connector.grpc.saga.GrpcSagaClientMessageSender;
import org.apache.servicecomb.pack.omega.connector.grpc.tcc.GrpcTccClientMessageSender;
import org.apache.servicecomb.pack.omega.context.ServiceConfig;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;

public class LoadBalanceContextBuilder {
    private final AlphaClusterConfig clusterConfig;
    private final ServiceConfig serviceConfig;
    private final int reconnectDelay;
    private final int timeoutSeconds;
    private final TransactionType transactionType;

    public LoadBalanceContextBuilder(TransactionType transactionType, AlphaClusterConfig clusterConfig, ServiceConfig serviceConfig, int reconnectDelay, int timeoutSeconds) {
        this.transactionType = transactionType;
        this.clusterConfig = clusterConfig;
        this.serviceConfig = serviceConfig;
        this.reconnectDelay = reconnectDelay;
        this.timeoutSeconds = timeoutSeconds;
    }

    public LoadBalanceContext build() {
        if (this.clusterConfig.getAddresses().isEmpty()) {
            throw new IllegalArgumentException("No reachable cluster address provided");
        }
        Optional<SslContext> sslContext = this.buildSslContext(this.clusterConfig);
        ConcurrentHashMap<MessageSender, Long> senders = new ConcurrentHashMap<MessageSender, Long>();
        ArrayList<ManagedChannel> channels = new ArrayList<ManagedChannel>(this.clusterConfig.getAddresses().size());
        LoadBalanceContext loadContext = new LoadBalanceContext(senders, channels, this.reconnectDelay, this.timeoutSeconds);
        for (String address : this.clusterConfig.getAddresses()) {
            ManagedChannel channel = this.buildChannel(address, sslContext);
            channels.add(channel);
            MessageSender messageSender = this.buildSender(address, channel, this.clusterConfig, this.serviceConfig, loadContext);
            senders.put(messageSender, 0L);
        }
        return loadContext;
    }

    private ManagedChannel buildChannel(String address, Optional<SslContext> sslContext) {
        if (sslContext.isPresent()) {
            return NettyChannelBuilder.forTarget((String)address).negotiationType(NegotiationType.TLS).sslContext((SslContext)sslContext.get()).build();
        }
        return ManagedChannelBuilder.forTarget((String)address).usePlaintext().build();
    }

    private MessageSender buildSender(String address, ManagedChannel channel, AlphaClusterConfig clusterConfig, ServiceConfig serviceConfig, LoadBalanceContext loadContext) {
        switch (this.transactionType) {
            case TCC: {
                return new GrpcTccClientMessageSender(serviceConfig, channel, address, clusterConfig.getTccMessageHandler(), loadContext);
            }
            case SAGA: {
                return new GrpcSagaClientMessageSender(address, channel, clusterConfig.getMessageSerializer(), clusterConfig.getMessageDeserializer(), serviceConfig, clusterConfig.getMessageHandler(), loadContext);
            }
        }
        return null;
    }

    private Optional<SslContext> buildSslContext(AlphaClusterConfig clusterConfig) {
        if (!clusterConfig.isEnableSSL()) {
            return Optional.absent();
        }
        SslContextBuilder builder = GrpcSslContexts.forClient();
        builder.sslProvider(SslProvider.OPENSSL);
        Properties prop = new Properties();
        try {
            prop.load(LoadBalanceContextBuilder.class.getClassLoader().getResourceAsStream("ssl.properties"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read ssl.properties.", e);
        }
        builder.protocols(prop.getProperty("protocols").split(","));
        builder.ciphers(Arrays.asList(prop.getProperty("ciphers").split(",")));
        builder.trustManager(new File(clusterConfig.getCertChain()));
        if (clusterConfig.isEnableMutualAuth()) {
            builder.keyManager(new File(clusterConfig.getCert()), new File(clusterConfig.getKey()));
        }
        try {
            return Optional.of((Object)builder.build());
        }
        catch (SSLException e) {
            throw new IllegalArgumentException("Unable to build SslContext", e);
        }
    }
}

