/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc.core;

import com.google.common.base.Supplier;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.pack.omega.connector.grpc.core.PushBackReconnectRunnable;
import org.apache.servicecomb.pack.omega.transaction.MessageSender;
import org.apache.servicecomb.pack.omega.transaction.OmegaException;

public class GrpcOnErrorHandler {
    private final BlockingQueue<Runnable> pendingTasks;
    private final Map<MessageSender, Long> senders;
    private final GrpcRetryContext grpcRetryContext;

    public GrpcOnErrorHandler(BlockingQueue<Runnable> pendingTasks, Map<MessageSender, Long> senders, int timeoutSeconds) {
        this.pendingTasks = pendingTasks;
        this.senders = senders;
        this.grpcRetryContext = new GrpcRetryContext(timeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(MessageSender messageSender) {
        PushBackReconnectRunnable runnable = new PushBackReconnectRunnable(messageSender, this.senders, this.pendingTasks, this.grpcRetryContext.getReconnectedSenders());
        BlockingQueue<Runnable> blockingQueue = this.pendingTasks;
        synchronized (blockingQueue) {
            if (!this.pendingTasks.contains(runnable)) {
                this.pendingTasks.offer(runnable);
            }
        }
    }

    public GrpcRetryContext getGrpcRetryContext() {
        return this.grpcRetryContext;
    }

    public static class GrpcRetryContext {
        private final int timeoutSeconds;
        private final BlockingQueue<MessageSender> reconnectedSenders = new LinkedBlockingQueue<MessageSender>();
        private final Supplier<MessageSender> defaultMessageSender = new Supplier<MessageSender>(){

            public MessageSender get() {
                try {
                    MessageSender messageSender = (MessageSender)GrpcRetryContext.this.reconnectedSenders.poll(GrpcRetryContext.this.timeoutSeconds, TimeUnit.SECONDS);
                    if (null == messageSender) {
                        throw new OmegaException("Failed to get reconnected sender, all alpha server is down.");
                    }
                    return messageSender;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OmegaException("Failed to get reconnected sender", (Throwable)e);
                }
            }
        };

        public GrpcRetryContext(int timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public BlockingQueue<MessageSender> getReconnectedSenders() {
            return this.reconnectedSenders;
        }

        public Supplier<MessageSender> getDefaultMessageSender() {
            return this.defaultMessageSender;
        }
    }
}

