/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.connector.grpc;

public class AlphaClusterDiscovery {
    private DiscoveryType discoveryType = DiscoveryType.DEFAULT;
    private String[] addresses;
    private String discoveryInfo;

    public DiscoveryType getDiscoveryType() {
        return this.discoveryType;
    }

    public void setDiscoveryType(DiscoveryType discoveryType) {
        this.discoveryType = discoveryType;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public void setAddresses(String[] addresses) {
        this.addresses = addresses;
    }

    public String getDiscoveryInfo() {
        return this.discoveryInfo;
    }

    public void setDiscoveryInfo(String discoveryInfo) {
        this.discoveryInfo = discoveryInfo;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DiscoveryType discoveryType = DiscoveryType.DEFAULT;
        private String[] addresses;
        private String discoveryInfo;

        public Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        public Builder discoveryInfo(String discoveryInfo) {
            this.discoveryInfo = discoveryInfo;
            return this;
        }

        public Builder addresses(String[] addresses) {
            this.addresses = addresses;
            return this;
        }

        public AlphaClusterDiscovery build() {
            AlphaClusterDiscovery alphaClusterDiscovery = new AlphaClusterDiscovery();
            alphaClusterDiscovery.setDiscoveryType(this.discoveryType);
            alphaClusterDiscovery.setAddresses(this.addresses);
            alphaClusterDiscovery.setDiscoveryInfo(this.discoveryInfo);
            return alphaClusterDiscovery;
        }
    }

    public static enum DiscoveryType {
        DEFAULT,
        EUREKA,
        CONSUL,
        ZOOKEEPER,
        NACOS;

    }
}

