/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicecomb.pack.omega.transaction.tcc.events;

import org.apache.servicecomb.pack.common.TransactionStatus;

public class TccEndedEvent {
  private final String globalTxId;
  private final String localTxId;
  private final TransactionStatus status;


  public String getGlobalTxId() {
    return globalTxId;
  }

  public String getLocalTxId() {
    return localTxId;
  }

  public TransactionStatus getStatus() {
    return status;
  }

  public TccEndedEvent(String globalTxId, String localTxId,
      TransactionStatus status) {
    this.globalTxId = globalTxId;
    this.localTxId = localTxId;
    this.status = status;
  }

  @Override
  public String toString() {
    return "TccEndedEvent{" +
        "globalTxId='" + globalTxId + '\'' +
        ", localTxId='" + localTxId + '\'' +
        ", status=" + status +
        '}';
  }
}
