/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpResponse;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.apache.servicecomb.http.client.common.HttpUtils;
import org.apache.servicecomb.service.center.client.OperationEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterAddressManager;
import org.apache.servicecomb.service.center.client.ServiceCenterOperation;
import org.apache.servicecomb.service.center.client.ServiceCenterRawClient;
import org.apache.servicecomb.service.center.client.exception.OperationException;
import org.apache.servicecomb.service.center.client.model.CreateMicroserviceInstanceRequest;
import org.apache.servicecomb.service.center.client.model.CreateMicroserviceRequest;
import org.apache.servicecomb.service.center.client.model.CreateSchemaRequest;
import org.apache.servicecomb.service.center.client.model.ErrorMessage;
import org.apache.servicecomb.service.center.client.model.FindMicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.GetSchemaListResponse;
import org.apache.servicecomb.service.center.client.model.GetSchemaResponse;
import org.apache.servicecomb.service.center.client.model.HeartbeatsRequest;
import org.apache.servicecomb.service.center.client.model.Microservice;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceResponse;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstanceStatus;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstancesResponse;
import org.apache.servicecomb.service.center.client.model.MicroserviceResponse;
import org.apache.servicecomb.service.center.client.model.MicroservicesResponse;
import org.apache.servicecomb.service.center.client.model.ModifySchemasRequest;
import org.apache.servicecomb.service.center.client.model.RbacTokenRequest;
import org.apache.servicecomb.service.center.client.model.RbacTokenResponse;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceInstanceResponse;
import org.apache.servicecomb.service.center.client.model.RegisteredMicroserviceResponse;
import org.apache.servicecomb.service.center.client.model.SchemaInfo;
import org.apache.servicecomb.service.center.client.model.UpdatePropertiesRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterClient
implements ServiceCenterOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterClient.class);
    private final ServiceCenterRawClient httpClient;
    private EventBus eventBus;
    private ServiceCenterAddressManager addressManager;

    public ServiceCenterClient(ServiceCenterRawClient httpClient) {
        this.httpClient = httpClient;
    }

    public ServiceCenterClient setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
        this.addressManager.setEventBus(eventBus);
        return this;
    }

    public ServiceCenterClient(ServiceCenterAddressManager addressManager, HttpConfiguration.SSLProperties sslProperties, RequestAuthHeaderProvider requestAuthHeaderProvider, String tenantName, Map<String, String> extraGlobalHeaders) {
        HttpTransport httpTransport = HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)sslProperties, (RequestAuthHeaderProvider)requestAuthHeaderProvider);
        httpTransport.addHeaders(extraGlobalHeaders);
        this.httpClient = new ServiceCenterRawClient.Builder().setTenantName(tenantName).setAddressManager(addressManager).setHttpTransport(httpTransport).build();
        this.addressManager = addressManager;
    }

    @Override
    public MicroserviceInstancesResponse getServiceCenterInstances() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/health", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service-center instances fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service-center instances fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceResponse registerMicroservice(Microservice microservice) {
        try {
            CreateMicroserviceRequest request = new CreateMicroserviceRequest();
            request.setService(microservice);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("register service fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service fails", e);
        }
    }

    @Override
    public MicroservicesResponse getMicroserviceList() {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroservicesResponse)HttpUtils.deserialize((String)response.getContent(), MicroservicesResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service List fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service List fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceResponse queryServiceId(Microservice microservice) {
        try {
            URIBuilder uriBuilder = new URIBuilder("/registry/existence");
            uriBuilder.setParameter("type", "microservice");
            uriBuilder.setParameter("appId", microservice.getAppId());
            uriBuilder.setParameter("serviceName", microservice.getServiceName());
            uriBuilder.setParameter("version", microservice.getVersion());
            uriBuilder.setParameter("env", microservice.getEnvironment());
            HttpResponse response = this.httpClient.getHttpRequest(uriBuilder.build().toString(), null, null);
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            LOGGER.info("Query serviceId fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
            return null;
        }
        catch (IOException e) {
            throw new OperationException("query serviceId fails", e);
        }
        catch (URISyntaxException e) {
            throw new OperationException("build url failed.", e);
        }
    }

    @Override
    public Microservice getMicroserviceByServiceId(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId, null, null);
            if (response.getStatusCode() == 200) {
                MicroserviceResponse microserviceResponse = (MicroserviceResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceResponse.class);
                return microserviceResponse.getService();
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service message fails", e);
        }
    }

    @Override
    public RegisteredMicroserviceInstanceResponse registerMicroserviceInstance(MicroserviceInstance instance) {
        try {
            CreateMicroserviceInstanceRequest request = new CreateMicroserviceInstanceRequest();
            request.setInstance(instance);
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices/" + instance.getServiceId() + "/instances", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return (RegisteredMicroserviceInstanceResponse)HttpUtils.deserialize((String)response.getContent(), RegisteredMicroserviceInstanceResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("register service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("register service instance fails", e);
        }
    }

    @Override
    public FindMicroserviceInstancesResponse findMicroserviceInstance(String consumerId, String appId, String serviceName, String versionRule, String revision) {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-ConsumerId", consumerId);
            HttpResponse response = this.httpClient.getHttpRequest("/registry/instances?appId=" + URLEncoder.encode(appId, "UTF-8") + "&serviceName=" + HttpUtils.encodeURLParam((String)serviceName) + "&version=" + HttpUtils.encodeURLParam((String)versionRule) + "&rev=" + HttpUtils.encodeURLParam((String)revision), headers, null);
            FindMicroserviceInstancesResponse result = new FindMicroserviceInstancesResponse();
            if (response.getStatusCode() == 200) {
                result.setModified(true);
                result.setRevision(response.getHeader("X-Resource-Revision"));
                result.setMicroserviceInstancesResponse((MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class));
                return result;
            }
            if (response.getStatusCode() == 304) {
                result.setModified(false);
                return result;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service instances list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instances list fails", e);
        }
    }

    @Override
    public MicroserviceInstancesResponse getMicroserviceInstanceList(String serviceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances", null, null);
            if (response.getStatusCode() == 200) {
                return (MicroserviceInstancesResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstancesResponse.class);
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service instances list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instances list fails", e);
        }
    }

    @Override
    public MicroserviceInstance getMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() == 200) {
                MicroserviceInstanceResponse instanceResponse = (MicroserviceInstanceResponse)HttpUtils.deserialize((String)response.getContent(), MicroserviceInstanceResponse.class);
                return instanceResponse.getInstance();
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service instance message fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service instance message fails", e);
        }
    }

    @Override
    public void deleteMicroserviceInstance(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.deleteHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId, null, null);
            if (response.getStatusCode() == 200) {
                LOGGER.info("Delete service instance successfully.");
                return;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("delete service instance fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("delete service instance fails", e);
        }
    }

    @Override
    public boolean updateMicroserviceInstanceStatus(String serviceId, String instanceId, MicroserviceInstanceStatus status) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/status?value=" + status, null, null);
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("update service instance status fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service instance status fails", e);
        }
    }

    @Override
    public void sendHeartBeats(HeartbeatsRequest heartbeatsRequest) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/heartbeats", null, HttpUtils.serialize((Object)heartbeatsRequest));
            if (response.getStatusCode() == 200) {
                return;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("heartbeats fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("heartbeats fails ", e);
        }
    }

    @Override
    public boolean sendHeartBeat(String serviceId, String instanceId) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/instances/" + instanceId + "/heartbeat", null, null);
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("heartbeats fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("heartbeats fails ", e);
        }
    }

    @Override
    public List<SchemaInfo> getServiceSchemasList(String serviceId, boolean withContent) {
        String url = "/registry/microservices/" + serviceId + "/schemas";
        if (withContent) {
            url = url + "?withSchema=1";
        }
        try {
            HttpResponse response = this.httpClient.getHttpRequest(url, null, null);
            if (response.getStatusCode() == 200) {
                GetSchemaListResponse getSchemaResponse = (GetSchemaListResponse)HttpUtils.deserialize((String)response.getContent(), GetSchemaListResponse.class);
                return getSchemaResponse.getSchemas();
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service schemas list fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas list fails", e);
        }
    }

    public String getServiceSchemaContext(String serviceId, String schemaId) {
        try {
            HttpResponse response = this.httpClient.getHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, null);
            if (response.getStatusCode() == 200) {
                GetSchemaResponse getSchemaResponse = (GetSchemaResponse)HttpUtils.deserialize((String)response.getContent(), GetSchemaResponse.class);
                return getSchemaResponse.getSchema();
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("get service schema context fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("get service schemas context fails", e);
        }
    }

    @Override
    public boolean registerSchema(String serviceId, String schemaId, CreateSchemaRequest schema) {
        try {
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaId, null, HttpUtils.serialize((Object)schema));
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }

    @Override
    public boolean updateServiceSchemaContext(String serviceId, SchemaInfo schemaInfo) {
        try {
            CreateSchemaRequest request = new CreateSchemaRequest();
            request.setSchema(schemaInfo.getSchema());
            request.setSummary(schemaInfo.getSummary());
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/schemas/" + schemaInfo.getSchemaId(), null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }

    @Override
    public boolean batchUpdateServiceSchemaContext(String serviceId, ModifySchemasRequest modifySchemasRequest) {
        try {
            HttpResponse response = this.httpClient.postHttpRequest("/registry/microservices/" + serviceId + "/schemas", null, HttpUtils.serialize((Object)modifySchemasRequest));
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("update service schema fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service schema fails", e);
        }
    }

    private void sendUnAuthorizedEvent(HttpResponse response) {
        if (this.eventBus != null && response.getStatusCode() == 401) {
            this.eventBus.post((Object)new OperationEvents.UnAuthorizedOperationEvent());
        }
    }

    @Override
    public RbacTokenResponse queryToken(RbacTokenRequest request) {
        try {
            HttpResponse response = this.httpClient.postHttpRequestAbsoluteUrl("/v4/token", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                RbacTokenResponse result = (RbacTokenResponse)HttpUtils.deserialize((String)response.getContent(), RbacTokenResponse.class);
                result.setStatusCode(200);
                return result;
            }
            if (response.getStatusCode() == 404) {
                RbacTokenResponse result = new RbacTokenResponse();
                result.setStatusCode(response.getStatusCode());
                return result;
            }
            if (response.getStatusCode() == 401 || response.getStatusCode() == 403) {
                RbacTokenResponse result = new RbacTokenResponse();
                result.setStatusCode(response.getStatusCode());
                ErrorMessage errorMessage = (ErrorMessage)HttpUtils.deserialize((String)response.getContent(), ErrorMessage.class);
                result.setErrorCode(errorMessage.getErrorCode());
                return result;
            }
            throw new OperationException("query token failed, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("query token failed", e);
        }
    }

    @Override
    public boolean updateMicroserviceProperties(String serviceId, Map<String, String> serviceProperties) {
        try {
            UpdatePropertiesRequest request = new UpdatePropertiesRequest();
            request.setProperties(serviceProperties);
            HttpResponse response = this.httpClient.putHttpRequest("/registry/microservices/" + serviceId + "/properties", null, HttpUtils.serialize((Object)request));
            if (response.getStatusCode() == 200) {
                return true;
            }
            this.sendUnAuthorizedEvent(response);
            throw new OperationException("update service instance status fails, statusCode = " + response.getStatusCode() + "; message = " + response.getMessage() + "; content = " + response.getContent());
        }
        catch (IOException e) {
            throw new OperationException("update service instance status fails", e);
        }
    }

    @Override
    public void checkIsolationAddressAvailable() {
        List isolationAddresses = this.addressManager.getIsolationAddresses();
        if (isolationAddresses.isEmpty()) {
            return;
        }
        for (String address : isolationAddresses) {
            this.httpClient.checkAddressAvailable("/registry/microservices", null, null, address);
        }
    }
}

