/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.nacos;

import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.api.RegistrationInstance;
import org.springframework.core.env.Environment;

public class NacosRegistrationInstance
implements RegistrationInstance {
    private final Instance instance;
    private final Map<String, String> schemas = new HashMap<String, String>();
    private final List<String> endpoints = new ArrayList<String>();
    private final Environment environment;

    public NacosRegistrationInstance(Instance instance, Environment environment) {
        this.instance = instance;
        this.environment = environment;
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Environment)this.environment);
    }

    public String getApplication() {
        return BootStrapProperties.readApplication((Environment)this.environment);
    }

    public String getServiceName() {
        return BootStrapProperties.readServiceName((Environment)this.environment);
    }

    public String getAlias() {
        return BootStrapProperties.readServiceAlias((Environment)this.environment);
    }

    public String getVersion() {
        return (String)this.instance.getMetadata().get("scb-version");
    }

    public DataCenterInfo getDataCenterInfo() {
        DataCenterInfo dataCenterInfo = new DataCenterInfo();
        dataCenterInfo.setRegion((String)this.instance.getMetadata().get("scb-region"));
        dataCenterInfo.setAvailableZone((String)this.instance.getMetadata().get("scb-zone"));
        return dataCenterInfo;
    }

    public String getDescription() {
        return BootStrapProperties.readServiceDescription((Environment)this.environment);
    }

    public Map<String, String> getProperties() {
        return this.instance.getMetadata();
    }

    public Map<String, String> getSchemas() {
        return this.schemas;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public String getInstanceId() {
        return this.instance.getInstanceId();
    }

    public MicroserviceInstanceStatus getInitialStatus() {
        return MicroserviceInstanceStatus.STARTING;
    }

    public MicroserviceInstanceStatus getReadyStatus() {
        return MicroserviceInstanceStatus.UP;
    }

    public void addSchema(String schemaId, String content) {
        this.schemas.put(schemaId, content);
    }

    public void addEndpoint(String endpoint) {
        this.endpoints.add(endpoint);
    }
}

