/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

public class InMemoryDynamicPropertiesSource
implements DynamicPropertiesSource {
    public static final String SOURCE_NAME = "in-memory";
    private static final Map<String, Object> DYNAMIC = new HashMap<String, Object>();

    @Override
    public MapPropertySource create(Environment environment) {
        return new MapPropertySource(SOURCE_NAME, DYNAMIC);
    }

    public int getOrder() {
        return -100;
    }

    public static void update(String key, Object value) {
        DYNAMIC.put(key, value);
        HashMap<String, Object> updated = new HashMap<String, Object>();
        updated.put(key, value);
        EventManager.post((Object)ConfigurationChangedEvent.createIncremental(updated));
    }

    public static void reset() {
        DYNAMIC.clear();
    }
}

