/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.param.FormProcessorCreator;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.common.rest.definition.path.PathRegExp;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;
import org.apache.servicecomb.common.rest.locator.OperationLocator;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.SwaggerConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestOperationMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestOperationMeta.class);
    protected OperationMeta operationMeta;
    protected boolean formData;
    protected boolean downloadFile;
    protected boolean serverSendEvents;
    protected List<RestParam> paramList = new ArrayList<RestParam>();
    protected Map<String, RestParam> paramMap = new LinkedHashMap<String, RestParam>();
    protected List<String> fileKeys = new ArrayList<String>();
    protected String absolutePath;
    protected PathRegExp absolutePathRegExp;
    private URLPathBuilder pathBuilder;

    public void init(OperationMeta operationMeta) {
        this.operationMeta = operationMeta;
        OpenAPI swagger = operationMeta.getSchemaMeta().getSwagger();
        Operation operation = operationMeta.getSwaggerOperation();
        this.downloadFile = this.checkDownloadFileFlag();
        this.serverSendEvents = this.checkServerSendEvents();
        if (operation.getParameters() != null) {
            for (int swaggerParameterIdx = 0; swaggerParameterIdx < operation.getParameters().size(); ++swaggerParameterIdx) {
                Parameter parameter = (Parameter)operation.getParameters().get(swaggerParameterIdx);
                Type type = operationMeta.getSwaggerProducerOperation() != null ? (Type)operationMeta.getSwaggerProducerOperation().getSwaggerParameterTypes().get(parameter.getName()) : null;
                RestParam param = new RestParam(operationMeta, parameter, type);
                this.addParam(param);
            }
        }
        if (operation.getRequestBody() != null) {
            if (this.isFormParameters(operation)) {
                this.formData = true;
                Schema formSchema = this.formSchemas(operation);
                if (formSchema != null) {
                    formSchema.getProperties().forEach((k, v) -> this.addRestParamByName(operationMeta, (String)k, operation));
                }
            } else {
                this.addRestParamByName(operationMeta, (String)operation.getRequestBody().getExtensions().get("x-name"), operation);
            }
        }
        this.setAbsolutePath(this.concatPath(SwaggerUtils.getBasePath((OpenAPI)swagger), operationMeta.getOperationPath()));
    }

    private void addRestParamByName(OperationMeta operationMeta, String name, Operation operation) {
        Type type = operationMeta.getSwaggerProducerOperation() != null ? (Type)operationMeta.getSwaggerProducerOperation().getSwaggerParameterTypes().get(name) : null;
        RestParam param = new RestParam(operationMeta, name, operation.getRequestBody(), this.formData, type);
        this.addParam(param);
    }

    private boolean isFormParameters(Operation operation) {
        return operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded") != null || operation.getRequestBody().getContent().get((Object)"multipart/form-data") != null;
    }

    private Schema formSchemas(Operation operation) {
        if (operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded") != null) {
            return ((MediaType)operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded")).getSchema();
        }
        return ((MediaType)operation.getRequestBody().getContent().get((Object)"multipart/form-data")).getSchema();
    }

    public boolean isDownloadFile() {
        return this.downloadFile;
    }

    public boolean isServerSendEvents() {
        return this.serverSendEvents;
    }

    private boolean checkServerSendEvents() {
        ApiResponses responses = this.operationMeta.getSwaggerOperation().getResponses();
        if (responses == null) {
            return false;
        }
        ApiResponse response = (ApiResponse)responses.get((Object)SwaggerConst.SUCCESS_KEY);
        return response != null && response.getContent() != null && response.getContent().get((Object)"text/event-stream") != null;
    }

    private boolean checkDownloadFileFlag() {
        ApiResponses responses = this.operationMeta.getSwaggerOperation().getResponses();
        if (responses == null) {
            return false;
        }
        ApiResponse response = (ApiResponse)responses.get((Object)SwaggerConst.SUCCESS_KEY);
        if (response != null && response.getContent() != null) {
            for (MediaType mediaType : response.getContent().values()) {
                if (mediaType.getSchema() == null || !"string".equals(mediaType.getSchema().getType()) || !"binary".equals(mediaType.getSchema().getFormat())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFormData() {
        return this.formData;
    }

    public void setOperationMeta(OperationMeta operationMeta) {
        this.operationMeta = operationMeta;
    }

    private String concatPath(String basePath, String operationPath) {
        return ("/" + this.nonNullify(basePath) + "/" + this.nonNullify(operationPath)).replaceAll("/{2,}", "/");
    }

    private String nonNullify(String path) {
        return path == null ? "" : path;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
        this.absolutePathRegExp = this.createPathRegExp(absolutePath);
        this.pathBuilder = new URLPathBuilder(absolutePath, this.paramMap);
    }

    public PathRegExp getAbsolutePathRegExp() {
        return this.absolutePathRegExp;
    }

    public boolean isAbsoluteStaticPath() {
        return this.absolutePathRegExp.isStaticPath();
    }

    protected PathRegExp createPathRegExp(String path) {
        if (path == null || path.equals("")) {
            throw new Error("null rest url is not supported");
        }
        try {
            return new PathRegExp(OperationLocator.getStandardPath(path));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    public RestParam getParamByName(String name) {
        return this.paramMap.get(name);
    }

    public OperationMeta getOperationMeta() {
        return this.operationMeta;
    }

    public URLPathBuilder getPathBuilder() {
        return this.pathBuilder;
    }

    public List<RestParam> getParamList() {
        return this.paramList;
    }

    private void addParam(RestParam param) {
        if (param.getParamProcessor() instanceof FormProcessorCreator.PartProcessor) {
            this.fileKeys.add(param.getParamName());
        }
        this.paramList.add(param);
        this.paramMap.put(param.getParamName(), param);
    }

    public String getHttpMethod() {
        return this.operationMeta.getHttpMethod();
    }

    public List<String> getFileKeys() {
        return this.fileKeys;
    }
}

