/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SwaggerGeneratorContext {
    protected static final List<String> SUPPORTED_CONTENT_TYPE = Arrays.asList("application/json", "application/protobuf", "text/plain", "multipart/form-data", "application/x-www-form-urlencoded", "text/event-stream");
    protected static final List<String> SUPPORTED_BODY_CONTENT_TYPE = Arrays.asList("application/json", "application/protobuf", "text/plain");
    protected static final List<String> SUPPORTED_FORM_CONTENT_TYPE = Arrays.asList("multipart/form-data", "application/x-www-form-urlencoded");
    protected List<String> supportedConsumes = new ArrayList<String>();
    protected List<String> supportedProduces;

    public SwaggerGeneratorContext() {
        this.supportedConsumes.addAll(SUPPORTED_CONTENT_TYPE);
        this.supportedProduces = new ArrayList<String>();
        this.supportedProduces.addAll(SUPPORTED_CONTENT_TYPE);
    }

    public SwaggerGeneratorContext(SwaggerGeneratorContext parent) {
        this.supportedConsumes.addAll(parent.supportedConsumes);
        this.supportedProduces = new ArrayList<String>();
        this.supportedProduces.addAll(parent.supportedProduces);
    }

    public void updateProduces(List<String> produces) {
        this.checkMediaTypeValid(produces);
        this.supportedProduces.clear();
        this.supportedProduces.addAll(produces);
    }

    public void updateConsumes(List<String> consumes) {
        this.checkMediaTypeValid(consumes);
        this.supportedConsumes.clear();
        this.supportedConsumes.addAll(consumes);
    }

    public List<String> getSupportedConsumes() {
        return this.supportedConsumes;
    }

    public List<String> getSupportedProduces() {
        return this.supportedProduces;
    }

    private void checkMediaTypeValid(List<String> produces) {
        for (String produce : produces) {
            if (SUPPORTED_CONTENT_TYPE.contains(produce)) continue;
            throw new IllegalArgumentException("Not support media type " + produce);
        }
    }
}

